/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.io.ConversionService;
import com.prowidesoftware.swift.model.SwiftMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnparsedTextList
implements Serializable {
    private static final long serialVersionUID = 7302986014143689797L;
    private Long id;
    private List<String> texts = new ArrayList<String>();

    public UnparsedTextList() {
    }

    public UnparsedTextList(Collection<String> texts) {
        Validate.notNull(texts, (String)"parameter 'texts' cannot be null");
        Validate.allElementsOfType(texts, String.class, (String)"parameter 'texts' may only have String elements");
        this.texts = new ArrayList<String>(texts);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAsFINString() {
        if (this.texts.isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        Iterator<String> itr = this.texts.iterator();
        while (itr.hasNext()) {
            s.append(itr.next());
        }
        return s.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static Boolean isMessage(String text) {
        return text != null && text.indexOf("{1:") >= 0;
    }

    public List<String> getTexts() {
        return this.texts;
    }

    protected void setTexts(List<String> texts) {
        this.texts = texts;
    }

    public Integer size() {
        return new Integer(this.texts.size());
    }

    public Boolean isMessage(Integer index) {
        return UnparsedTextList.isMessage(this.getText(index));
    }

    public String getText(Integer index) {
        Validate.notNull((Object)index, (String)"parameter 'index' cannot be null");
        return this.texts.get(index);
    }

    public SwiftMessage getTextAsMessage(Integer index) {
        Validate.notNull((Object)index, (String)"parameter 'index' cannot be null");
        ConversionService cService = new ConversionService();
        return cService.getMessageFromFIN(this.texts.get(index));
    }

    public void addText(String text) {
        Validate.notNull((Object)text, (String)"parameter 'text' cannot be null");
        this.texts.add(text);
    }

    public void addText(SwiftMessage message) {
        Validate.notNull((Object)message, (String)"parameter 'message' cannot be null");
        ConversionService cService = new ConversionService();
        String msg = cService.getFIN(message);
        this.addText(msg);
    }

    public void removeText(Integer index) {
        Validate.notNull((Object)index, (String)"parameter 'index' cannot be null");
        this.texts.remove(index);
    }

    public void removeText(int index) {
        this.texts.remove(index);
    }

    public void removeText(String text) {
        Validate.notNull((Object)text, (String)"parameter 'text' cannot be null");
        int pos = this.texts.indexOf(text);
        if (pos != -1) {
            this.texts.remove(pos);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.texts == null ? 0 : ((Object)this.texts).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnparsedTextList other = (UnparsedTextList)obj;
        return !(this.texts == null ? other.texts != null : !((Object)this.texts).equals(other.texts));
    }
}

