/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field23G
extends Field
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "23G";
    public static final String F_23G = "23G";
    public static final String PARSER_PATTERN = "S[/S]";
    public static final String COMPONENTS_PATTERN = "SS";
    public static final Integer FUNCTION = 1;
    public static final Integer SUBFUNCTION = 2;

    public Field23G() {
        super(2);
    }

    public Field23G(String value) {
        super(value);
    }

    public Field23G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"23G")) {
            throw new IllegalArgumentException("cannot create field 23G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, null, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    public static Field23G newInstance(Field23G source) {
        Field23G cp = new Field23G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("23G", value);
    }

    public static Tag emptyTag() {
        return new Tag("23G", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getFunction() {
        return this.getComponent(1);
    }

    public Field23G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field23G setFunction(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getSubfunction() {
        return this.getComponent(2);
    }

    public Field23G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field23G setSubfunction(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "23G";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4!c[/4!c]";
    }

    public static Field23G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("23G");
        if (t == null) {
            return null;
        }
        return new Field23G(t);
    }

    public static Field23G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field23G.get(msg.getBlock4());
    }

    public static List<Field23G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field23G.getAll(msg.getBlock4());
    }

    public static List<Field23G> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("23G");
        if (arr != null && arr.length > 0) {
            ArrayList<Field23G> result = new ArrayList<Field23G>(arr.length);
            for (Tag f : arr) {
                result.add(new Field23G(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 23G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Function");
        result.add("Subfunction");
        return result;
    }
}

