/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field29N
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "29N";
    public static final String F_29N = "29N";
    public static final String PARSER_PATTERN = "S/S/S";
    public static final String COMPONENTS_PATTERN = "DSH";
    public static final Integer DATE = 1;
    public static final Integer TIME = 3;

    public Field29N() {
        super(3);
    }

    public Field29N(String value) {
        super(value);
    }

    public Field29N(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"29N")) {
            throw new IllegalArgumentException("cannot create field 29N from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "/");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    public static Field29N newInstance(Field29N source) {
        Field29N cp = new Field29N();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("29N", value);
    }

    public static Tag emptyTag() {
        return new Tag("29N", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent(1);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public Field29N setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field29N setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field29N setDate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field29N setDate(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public Field29N setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getTime() {
        return this.getComponent(3);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public Field29N setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field29N setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field29N setTime(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field29N setTime(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(1)));
        result.add(SwiftFormatUtils.getTime3(this.getComponent(3)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "29N";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DATE4>/4!c/<HHMM>";
    }

    public static Field29N get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("29N");
        if (t == null) {
            return null;
        }
        return new Field29N(t);
    }

    public static Field29N get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field29N.get(msg.getBlock4());
    }

    public static List<Field29N> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field29N.getAll(msg.getBlock4());
    }

    public static List<Field29N> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("29N");
        if (arr != null && arr.length > 0) {
            ArrayList<Field29N> result = new ArrayList<Field29N>(arr.length);
            for (Tag f : arr) {
                result.add(new Field29N(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 29N");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add(null);
        result.add("Time");
        return result;
    }
}

