/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field33N
extends Field
implements Serializable,
CurrencyContainer,
DateContainer,
AmountContainer {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "33N";
    public static final String F_33N = "33N";
    public static final String PARSER_PATTERN = "[c]<DATE2>SN";
    public static final String COMPONENTS_PATTERN = "SECN";
    public static final Integer SIGN = 1;
    public static final Integer DATE = 2;
    public static final Integer CURRENCY = 3;
    public static final Integer AMOUNT = 4;

    public Field33N() {
        super(4);
    }

    public Field33N(String value) {
        super(value);
    }

    public Field33N(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"33N")) {
            throw new IllegalArgumentException("cannot create field 33N from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        String toparse = SwiftParseUtils.getNumericSuffix(value);
        this.setComponent2(SwiftParseUtils.getNumericPrefix(toparse));
        String toparse2 = SwiftParseUtils.getAlphaSuffix(toparse);
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(toparse2));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    public static Field33N newInstance(Field33N source) {
        Field33N cp = new Field33N();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("33N", value);
    }

    public static Tag emptyTag() {
        return new Tag("33N", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getSign() {
        return this.getComponent(1);
    }

    public Field33N setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field33N setSign(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field33N setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33N setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field33N setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33N setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrency() {
        return this.getComponent(3);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public Field33N setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field33N setComponent3(Currency component3) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(component3));
        return this;
    }

    public Field33N setCurrency(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field33N setCurrency(Currency component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent(4);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field33N setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field33N setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field33N setAmount(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field33N setAmount(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return result;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "33N";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[<N>]<DATE2><CUR><AMOUNT>15";
    }

    public static Field33N get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("33N");
        if (t == null) {
            return null;
        }
        return new Field33N(t);
    }

    public static Field33N get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field33N.get(msg.getBlock4());
    }

    public static List<Field33N> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field33N.getAll(msg.getBlock4());
    }

    public static List<Field33N> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("33N");
        if (arr != null && arr.length > 0) {
            ArrayList<Field33N> result = new ArrayList<Field33N>(arr.length);
            for (Tag f : arr) {
                result.add(new Field33N(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Format f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 33N");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Sign");
        result.add("Date");
        result.add("Currency");
        result.add("Amount");
        return result;
    }
}

