/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field37J
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "37J";
    public static final String F_37J = "37J";
    public static final String PARSER_PATTERN = "N";
    public static final String COMPONENTS_PATTERN = "N";
    public static final Integer RATE = 1;

    public Field37J() {
        super(1);
    }

    public Field37J(String value) {
        super(value);
    }

    public Field37J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"37J")) {
            throw new IllegalArgumentException("cannot create field 37J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(1);
        this.setComponent1(value);
    }

    public static Field37J newInstance(Field37J source) {
        Field37J cp = new Field37J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("37J", value);
    }

    public static Tag emptyTag() {
        return new Tag("37J", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getRate() {
        return this.getComponent(1);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field37J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37J setComponent1(Number component1) {
        this.setComponent(1, SwiftFormatUtils.getNumber(component1));
        return this;
    }

    public Field37J setRate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field37J setRate(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return "N";
    }

    @Override
    public String getName() {
        return "37J";
    }

    @Override
    public final String componentsPattern() {
        return "N";
    }

    @Override
    public final String validatorPattern() {
        return "<AMOUNT>12";
    }

    public static Field37J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("37J");
        if (t == null) {
            return null;
        }
        return new Field37J(t);
    }

    public static Field37J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field37J.get(msg.getBlock4());
    }

    public static List<Field37J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field37J.getAll(msg.getBlock4());
    }

    public static List<Field37J> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("37J");
        if (arr != null && arr.length > 0) {
            ArrayList<Field37J> result = new ArrayList<Field37J>(arr.length);
            for (Tag f : arr) {
                result.add(new Field37J(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 1;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 1) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 37J");
        }
        if (component == 1) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Rate");
        return result;
    }
}

