/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field38J
extends Field
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "38J";
    public static final String F_38J = "38J";
    public static final String PARSER_PATTERN = "SN";
    public static final String COMPONENTS_PATTERN = "SN";
    public static final Integer DM_MARK = 1;
    public static final Integer NUMBER = 2;

    public Field38J() {
        super(2);
    }

    public Field38J(String value) {
        super(value);
    }

    public Field38J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"38J")) {
            throw new IllegalArgumentException("cannot create field 38J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
    }

    public static Field38J newInstance(Field38J source) {
        Field38J cp = new Field38J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("38J", value);
    }

    public static Tag emptyTag() {
        return new Tag("38J", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDMMark() {
        return this.getComponent(1);
    }

    public Field38J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field38J setDMMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getNumber() {
        return this.getComponent(2);
    }

    public Number getNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field38J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field38J setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field38J setNumber(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field38J setNumber(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return "SN";
    }

    @Override
    public String getName() {
        return "38J";
    }

    @Override
    public final String componentsPattern() {
        return "SN";
    }

    @Override
    public final String validatorPattern() {
        return "<DM>3!n";
    }

    public static Field38J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("38J");
        if (t == null) {
            return null;
        }
        return new Field38J(t);
    }

    public static Field38J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field38J.get(msg.getBlock4());
    }

    public static List<Field38J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field38J.getAll(msg.getBlock4());
    }

    public static List<Field38J> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("38J");
        if (arr != null && arr.length > 0) {
            ArrayList<Field38J> result = new ArrayList<Field38J>(arr.length);
            for (Tag f : arr) {
                result.add(new Field38J(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 38J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/M Mark");
        result.add("Number");
        return result;
    }
}

