/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field41D
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "41D";
    public static final String F_41D = "41D";
    public static final String PARSER_PATTERN = "S[$S]0-3$S";
    public static final String COMPONENTS_PATTERN = "SSSSS";

    public Field41D() {
        super(5);
    }

    public Field41D(String value) {
        super(value);
    }

    public Field41D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"41D")) {
            throw new IllegalArgumentException("cannot create field 41D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        List<String> lines = SwiftParseUtils.getLines(value);
        String c5 = null;
        if (lines.size() > 1) {
            c5 = lines.remove(lines.size() > 5 ? 4 : lines.size() - 1);
        }
        if (!lines.isEmpty()) {
            this.setComponent1(lines.get(0));
            if (lines.size() > 1) {
                this.setComponent2(lines.get(1));
            }
            if (lines.size() > 2) {
                this.setComponent3(lines.get(2));
            }
            if (lines.size() > 3) {
                this.setComponent4(lines.get(3));
            }
        }
        if (c5 != null) {
            this.setComponent5(c5);
        }
    }

    public static Field41D newInstance(Field41D source) {
        Field41D cp = new Field41D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        for (String s : this.components) {
            result.append(StringUtils.trimToEmpty((String)s)).append("\r\n");
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("41D", value);
    }

    public static Tag emptyTag() {
        return new Tag("41D", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public Field41D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public Field41D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field41D setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public Field41D setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field41D setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "41D";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "35x[$35x]0-3$14x";
    }

    public static Field41D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("41D");
        if (t == null) {
            return null;
        }
        return new Field41D(t);
    }

    public static Field41D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field41D.get(msg.getBlock4());
    }

    public static List<Field41D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field41D.getAll(msg.getBlock4());
    }

    public static List<Field41D> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("41D");
        if (arr != null && arr.length > 0) {
            ArrayList<Field41D> result = new ArrayList<Field41D>(arr.length);
            for (Tag f : arr) {
                result.add(new Field41D(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field41D cp = Field41D.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field41D cp = Field41D.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field41D cp = Field41D.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 41D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        return result;
    }
}

