/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field50F
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "50F";
    public static final String F_50F = "50F";
    public static final String PARSER_PATTERN = "S$S/S[$S/S]0-3";
    public static final String COMPONENTS_PATTERN = "SNSNSNSNS";

    public Field50F() {
        super(9);
    }

    public Field50F(String value) {
        super(value);
    }

    public Field50F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"50F")) {
            throw new IllegalArgumentException("cannot create field 50F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(9);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(lines.get(0));
            if (lines.size() > 1) {
                this.setComponent2(SwiftParseUtils.getTokenFirst(lines.get(1), "/"));
                this.setComponent3(SwiftParseUtils.getTokenSecondLast(lines.get(1), "/"));
            }
            if (lines.size() > 2) {
                this.setComponent4(SwiftParseUtils.getTokenFirst(lines.get(2), "/"));
                this.setComponent5(SwiftParseUtils.getTokenSecondLast(lines.get(2), "/"));
            }
            if (lines.size() > 3) {
                this.setComponent6(SwiftParseUtils.getTokenFirst(lines.get(3), "/"));
                this.setComponent7(SwiftParseUtils.getTokenSecondLast(lines.get(3), "/"));
            }
            if (lines.size() > 4) {
                this.setComponent8(SwiftParseUtils.getTokenFirst(lines.get(4), "/"));
                this.setComponent9(SwiftParseUtils.getTokenSecondLast(lines.get(4), "/"));
            }
        }
    }

    public static Field50F newInstance(Field50F source) {
        Field50F cp = new Field50F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.getComponent1())) {
            if (!StringUtils.contains((String)this.getComponent1(), (String)"/")) {
                result.append("/");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent2()) || StringUtils.isNotEmpty((String)this.getComponent3())) {
            result.append("\r\n");
            result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent4()) || StringUtils.isNotEmpty((String)this.getComponent5())) {
            result.append("\r\n");
            result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent6()) || StringUtils.isNotEmpty((String)this.getComponent7())) {
            result.append("\r\n");
            result.append(StringUtils.trimToEmpty((String)this.getComponent6()));
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent7()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent8()) || StringUtils.isNotEmpty((String)this.getComponent9())) {
            result.append("\r\n");
            result.append(StringUtils.trimToEmpty((String)this.getComponent8()));
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent9()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("50F", value);
    }

    public static Tag emptyTag() {
        return new Tag("50F", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public Field50F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field50F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50F setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field50F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field50F setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field50F setComponent4(Number component4) {
        if (component4 != null) {
            this.setComponent(4, Integer.toString(component4.intValue()));
        }
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field50F setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public Field50F setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field50F setComponent6(Number component6) {
        if (component6 != null) {
            this.setComponent(6, Integer.toString(component6.intValue()));
        }
        return this;
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    @Deprecated
    public String getComponent7AsString() {
        return this.getComponent(7);
    }

    public Field50F setComponent7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public String getComponent8() {
        return this.getComponent(8);
    }

    public Number getComponent8AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public Field50F setComponent8(String component8) {
        this.setComponent(8, component8);
        return this;
    }

    public Field50F setComponent8(Number component8) {
        if (component8 != null) {
            this.setComponent(8, Integer.toString(component8.intValue()));
        }
        return this;
    }

    public String getComponent9() {
        return this.getComponent(9);
    }

    @Deprecated
    public String getComponent9AsString() {
        return this.getComponent(9);
    }

    public Field50F setComponent9(String component9) {
        this.setComponent(9, component9);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        if (component == 6) {
            return true;
        }
        if (component == 7) {
            return true;
        }
        if (component == 8) {
            return true;
        }
        return component == 9;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "50F";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "CUSTOM";
    }

    public static Field50F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("50F");
        if (t == null) {
            return null;
        }
        return new Field50F(t);
    }

    public static Field50F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field50F.get(msg.getBlock4());
    }

    public static List<Field50F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field50F.getAll(msg.getBlock4());
    }

    public static List<Field50F> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("50F");
        if (arr != null && arr.length > 0) {
            ArrayList<Field50F> result = new ArrayList<Field50F>(arr.length);
            for (Tag f : arr) {
                result.add(new Field50F(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 9;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field50F cp = Field50F.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field50F cp = Field50F.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field50F cp = Field50F.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 9) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 50F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent6AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 7) {
            return this.getComponent(7);
        }
        if (component == 8) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent8AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 9) {
            return this.getComponent(9);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        return result;
    }
}

