/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field50K
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "50K";
    public static final String F_50K = "50K";
    public static final String PARSER_PATTERN = "[/S$]S[$S]0-3";
    public static final String COMPONENTS_PATTERN = "SSSSS";
    public static final Integer ACCOUNT = 1;
    public static final Integer NAME_AND_ADDRESS = 2;

    public Field50K() {
        super(5);
    }

    public Field50K(String value) {
        super(value);
    }

    public Field50K(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"50K")) {
            throw new IllegalArgumentException("cannot create field 50K from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            if (lines.get(0).startsWith("/")) {
                this.setComponent1(StringUtils.trimToNull((String)StringUtils.substring((String)lines.get(0), (int)1)));
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 1, lines);
            } else {
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 0, lines);
            }
        }
    }

    public static Field50K newInstance(Field50K source) {
        Field50K cp = new Field50K();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.getComponent1())) {
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        }
        this.appendInLines(result, this.getComponent2(), this.getComponent3(), this.getComponent4(), this.getComponent5());
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("50K", value);
    }

    public static Tag emptyTag() {
        return new Tag("50K", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String c = this.getComponent(1);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field50K setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field50K setAccount(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getNameAndAddressLine1() {
        return this.getComponent(2);
    }

    public String getNameAndAddressLine2() {
        return this.getComponent(3);
    }

    public String getNameAndAddressLine3() {
        return this.getComponent(4);
    }

    public String getNameAndAddressLine4() {
        return this.getComponent(5);
    }

    public String getNameAndAddress() {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 6; ++i) {
            if (!StringUtils.isNotBlank((String)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public Field50K setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50K setNameAndAddressLine1(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50K setNameAndAddressLine2(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field50K setNameAndAddressLine3(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field50K setNameAndAddressLine4(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field50K setNameAndAddress(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 2, 4, 0, lines);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field50K setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public Field50K setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field50K setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        return component == 5;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "50K";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[/34x$]35x[$35x]0-3";
    }

    public static Field50K get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("50K");
        if (t == null) {
            return null;
        }
        return new Field50K(t);
    }

    public static Field50K get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field50K.get(msg.getBlock4());
    }

    public static List<Field50K> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field50K.getAll(msg.getBlock4());
    }

    public static List<Field50K> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("50K");
        if (arr != null && arr.length > 0) {
            ArrayList<Field50K> result = new ArrayList<Field50K>(arr.length);
            for (Tag f : arr) {
                result.add(new Field50K(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field50K cp = Field50K.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field50K cp = Field50K.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field50K cp = Field50K.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 50K");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Account");
        result.add("Name And Address");
        result.add("Name And Address 2");
        result.add("Name And Address 3");
        result.add("Name And Address 4");
        return result;
    }

    @Override
    public String getValueDisplay() {
        return Field50K.formatAccount(this.getComponent1()) + "\n" + this.getComponent2();
    }
}

