/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field68B
extends Field
implements Serializable,
CurrencyContainer,
DateContainer,
AmountContainer,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "68B";
    public static final String F_68B = "68B";
    public static final String PARSER_PATTERN = "<DATE2><DATE2>S/cSN$SN/<DATE2>SN";
    public static final String COMPONENTS_PATTERN = "EEScSNCNECN";
    public static final Integer TRADE_DATE = 1;
    public static final Integer MATURITY_DATE = 2;
    public static final Integer CONTRACT_NUMBER = 3;
    public static final Integer INDICATOR = 4;
    public static final Integer UNIT = 5;
    public static final Integer QUANTITY_OF_THE_COMMODITY = 6;
    public static final Integer PRICE_PER_UNIT_CURRENCY = 7;
    public static final Integer PRICE_PER_UNIT = 8;
    public static final Integer VALUE_DATE_OF_THE_CONSIDERATION = 9;
    public static final Integer CONSIDERATION_CURRENCY = 10;
    public static final Integer CONSIDERATION = 11;

    public Field68B() {
        super(11);
    }

    public Field68B(String value) {
        super(value);
    }

    public Field68B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"68B")) {
            throw new IllegalArgumentException("cannot create field 68B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        String toparse;
        this.init(11);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0) != null) {
            toparse = SwiftParseUtils.getTokenFirst(lines.get(0), "/");
            if (toparse != null) {
                if (toparse.length() >= 6) {
                    this.setComponent1(StringUtils.substring((String)toparse, (int)0, (int)6));
                }
                if (toparse.length() >= 12) {
                    this.setComponent2(StringUtils.substring((String)toparse, (int)6, (int)12));
                }
                if (toparse.length() > 12) {
                    this.setComponent3(StringUtils.substring((String)toparse, (int)12));
                }
            }
            if ((toparse = SwiftParseUtils.getAlphaPrefix(SwiftParseUtils.getTokenSecond(lines.get(0), "/"))) != null) {
                if (toparse.length() >= 1) {
                    this.setComponent4(StringUtils.substring((String)toparse, (int)0, (int)1));
                }
                if (toparse.length() > 1) {
                    this.setComponent5(StringUtils.substring((String)toparse, (int)1));
                }
            }
            this.setComponent6(SwiftParseUtils.getNumericSuffix(SwiftParseUtils.getTokenSecond(lines.get(0), "/")));
        }
        if (lines.size() > 1 && lines.get(1) != null) {
            toparse = SwiftParseUtils.getTokenFirst(lines.get(1), "/");
            this.setComponent7(SwiftParseUtils.getAlphaPrefix(toparse));
            this.setComponent8(SwiftParseUtils.getNumericSuffix(toparse));
            toparse = SwiftParseUtils.getTokenSecondLast(lines.get(1), "/");
            if (toparse != null && toparse.length() >= 6) {
                this.setComponent9(StringUtils.substring((String)toparse, (int)0, (int)6));
                String toparse2 = StringUtils.substring((String)toparse, (int)6);
                this.setComponent10(SwiftParseUtils.getAlphaPrefix(toparse2));
                this.setComponent11(SwiftParseUtils.getNumericSuffix(toparse2));
            }
        }
    }

    public static Field68B newInstance(Field68B source) {
        Field68B cp = new Field68B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent6()));
        result.append("\r\n");
        result.append(StringUtils.trimToEmpty((String)this.getComponent7()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent8()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent9()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent10()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent11()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("68B", value);
    }

    public static Tag emptyTag() {
        return new Tag("68B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getTradeDate() {
        return this.getComponent(1);
    }

    public Calendar getTradeDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public Field68B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field68B setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field68B setTradeDate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field68B setTradeDate(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getMaturityDate() {
        return this.getComponent(2);
    }

    public Calendar getMaturityDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field68B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field68B setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field68B setMaturityDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field68B setMaturityDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getContractNumber() {
        return this.getComponent(3);
    }

    public Field68B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field68B setContractNumber(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getIndicator() {
        return this.getComponent(4);
    }

    public Field68B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field68B setIndicator(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public String getUnit() {
        return this.getComponent(5);
    }

    public Field68B setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field68B setUnit(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public String getQuantityOfTheCommodity() {
        return this.getComponent(6);
    }

    public Number getQuantityOfTheCommodityAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public Field68B setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field68B setComponent6(Number component6) {
        this.setComponent(6, SwiftFormatUtils.getNumber(component6));
        return this;
    }

    public Field68B setQuantityOfTheCommodity(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field68B setQuantityOfTheCommodity(Number component6) {
        this.setComponent6(component6);
        return this;
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    public Currency getComponent7AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(7));
    }

    public String getPricePerUnitCurrency() {
        return this.getComponent(7);
    }

    public Currency getPricePerUnitCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(7));
    }

    public Field68B setComponent7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field68B setComponent7(Currency component7) {
        this.setComponent(7, SwiftFormatUtils.getCurrency(component7));
        return this;
    }

    public Field68B setPricePerUnitCurrency(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field68B setPricePerUnitCurrency(Currency component7) {
        this.setComponent7(component7);
        return this;
    }

    public String getComponent8() {
        return this.getComponent(8);
    }

    public Number getComponent8AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public String getPricePerUnit() {
        return this.getComponent(8);
    }

    public Number getPricePerUnitAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public Field68B setComponent8(String component8) {
        this.setComponent(8, component8);
        return this;
    }

    public Field68B setComponent8(Number component8) {
        this.setComponent(8, SwiftFormatUtils.getNumber(component8));
        return this;
    }

    public Field68B setPricePerUnit(String component8) {
        this.setComponent(8, component8);
        return this;
    }

    public Field68B setPricePerUnit(Number component8) {
        this.setComponent8(component8);
        return this;
    }

    public String getComponent9() {
        return this.getComponent(9);
    }

    public Calendar getComponent9AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(9));
    }

    public String getValueDateOfTheConsideration() {
        return this.getComponent(9);
    }

    public Calendar getValueDateOfTheConsiderationAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(9));
    }

    public Field68B setComponent9(String component9) {
        this.setComponent(9, component9);
        return this;
    }

    public Field68B setComponent9(Calendar component9) {
        this.setComponent(9, SwiftFormatUtils.getDate2(component9));
        return this;
    }

    public Field68B setValueDateOfTheConsideration(String component9) {
        this.setComponent(9, component9);
        return this;
    }

    public Field68B setValueDateOfTheConsideration(Calendar component9) {
        this.setComponent9(component9);
        return this;
    }

    public String getComponent10() {
        return this.getComponent(10);
    }

    public Currency getComponent10AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(10));
    }

    public String getConsiderationCurrency() {
        return this.getComponent(10);
    }

    public Currency getConsiderationCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(10));
    }

    public Field68B setComponent10(String component10) {
        this.setComponent(10, component10);
        return this;
    }

    public Field68B setComponent10(Currency component10) {
        this.setComponent(10, SwiftFormatUtils.getCurrency(component10));
        return this;
    }

    public Field68B setConsiderationCurrency(String component10) {
        this.setComponent(10, component10);
        return this;
    }

    public Field68B setConsiderationCurrency(Currency component10) {
        this.setComponent10(component10);
        return this;
    }

    public String getComponent11() {
        return this.getComponent(11);
    }

    public Number getComponent11AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(11));
    }

    public String getConsideration() {
        return this.getComponent(11);
    }

    public Number getConsiderationAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(11));
    }

    public Field68B setComponent11(String component11) {
        this.setComponent(11, component11);
        return this;
    }

    public Field68B setComponent11(Number component11) {
        this.setComponent(11, SwiftFormatUtils.getNumber(component11));
        return this;
    }

    public Field68B setConsideration(String component11) {
        this.setComponent(11, component11);
        return this;
    }

    public Field68B setConsideration(Number component11) {
        this.setComponent11(component11);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(1)));
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        result.add(SwiftFormatUtils.getDate2(this.getComponent(9)));
        return result;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "68B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DATE2><DATE2>16x/1a$3!a<AMOUNT>15$<CUR><AMOUNT>15/<DATE2><CUR><AMOUNT>15";
    }

    public static Field68B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("68B");
        if (t == null) {
            return null;
        }
        return new Field68B(t);
    }

    public static Field68B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field68B.get(msg.getBlock4());
    }

    public static List<Field68B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field68B.getAll(msg.getBlock4());
    }

    public static List<Field68B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("68B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field68B> result = new ArrayList<Field68B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field68B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 11;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field68B cp = Field68B.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field68B cp = Field68B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field68B cp = Field68B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        Calendar cal;
        Format f;
        if (component < 1 || component > 11) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 68B");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent6AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 7) {
            return this.getComponent(7);
        }
        if (component == 8) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent8AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 9) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent9AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 10) {
            return this.getComponent(10);
        }
        if (component == 11) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent11AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Trade Date");
        result.add("Maturity Date");
        result.add("Contract Number");
        result.add("Indicator");
        result.add("Unit");
        result.add("Quantity Of The Commodity");
        result.add("Price Per Unit Currency");
        result.add("Price Per Unit");
        result.add("Value Date Of The Consideration");
        result.add("Consideration Currency");
        result.add("Consideration");
        return result;
    }
}

