/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field68C
extends Field
implements Serializable,
CurrencyContainer,
DateContainer,
AmountContainer,
MultiLineField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "68C";
    public static final String F_68C = "68C";
    public static final String PARSER_PATTERN = "S/S/c[<DATE2>]SN$SNSNSN";
    public static final String COMPONENTS_PATTERN = "SScESNCNCNCN";
    public static final Integer BUYSELL_INDICATOR = 1;
    public static final Integer CALLPUT_INDICATOR = 2;
    public static final Integer STYLE_INDICATOR = 3;
    public static final Integer DATE_CONTRACT_AGREED = 4;
    public static final Integer UNIT = 5;
    public static final Integer AMOUNT_OF_THE_UNDERLYING_COMMODITY = 6;
    public static final Integer STRIKE_PRICE_PER_UNIT_CURRENCY = 7;
    public static final Integer STRIKE_PRICE_PER_UNIT = 8;
    public static final Integer PREMIUM_PRICE_PER_UNIT_CURRENCY = 9;
    public static final Integer PREMIUM_PRICE_PER_UNIT = 10;
    public static final Integer PREMIUM_PAYMENT_CURRENCY = 11;
    public static final Integer PREMIUM_PAYMENT = 12;

    public Field68C() {
        super(12);
    }

    public Field68C(String value) {
        super(value);
    }

    public Field68C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"68C")) {
            throw new IllegalArgumentException("cannot create field 68C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(12);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0) != null) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), "/"));
            this.setComponent2(SwiftParseUtils.getTokenSecond(lines.get(0), "/"));
            String toparse = SwiftParseUtils.getTokenThirdLast(lines.get(0), "/");
            if (toparse != null && toparse.length() >= 1) {
                StringBuilder parsed = new StringBuilder();
                this.setComponent3(StringUtils.substring((String)toparse, (int)0, (int)1));
                if (this.getComponent3() != null) {
                    parsed.append(this.getComponent3());
                }
                String toparse2 = StringUtils.substringAfter((String)toparse, (String)parsed.toString());
                this.setComponent4(SwiftParseUtils.getNumericPrefix(toparse2));
                if (this.getComponent4() != null) {
                    parsed.append(this.getComponent4());
                }
                toparse2 = StringUtils.substringAfter((String)toparse, (String)parsed.toString());
                this.setComponent5(SwiftParseUtils.getAlphaPrefix(toparse2));
                this.setComponent6(SwiftParseUtils.getNumericSuffix(toparse2));
            }
        }
        if (lines.size() > 1 && lines.get(1) != null) {
            StringBuilder parsed = new StringBuilder();
            String l = lines.get(1);
            this.setComponent7(SwiftParseUtils.getAlphaPrefix(l));
            if (this.getComponent7() != null) {
                parsed.append(this.getComponent7());
            }
            String toparse = StringUtils.substringAfter((String)l, (String)parsed.toString());
            this.setComponent8(SwiftParseUtils.getNumericPrefix(toparse));
            if (this.getComponent8() != null) {
                parsed.append(this.getComponent8());
            }
            toparse = StringUtils.substringAfter((String)l, (String)parsed.toString());
            this.setComponent9(SwiftParseUtils.getAlphaPrefix(toparse));
            if (this.getComponent9() != null) {
                parsed.append(this.getComponent9());
            }
            toparse = StringUtils.substringAfter((String)l, (String)parsed.toString());
            this.setComponent10(SwiftParseUtils.getNumericPrefix(toparse));
            if (this.getComponent10() != null) {
                parsed.append(this.getComponent10());
            }
            toparse = StringUtils.substringAfter((String)l, (String)parsed.toString());
            this.setComponent11(SwiftParseUtils.getAlphaPrefix(toparse));
            if (this.getComponent11() != null) {
                parsed.append(this.getComponent11());
            }
            toparse = StringUtils.substringAfter((String)l, (String)parsed.toString());
            this.setComponent12(SwiftParseUtils.getNumericPrefix(toparse));
        }
    }

    public static Field68C newInstance(Field68C source) {
        Field68C cp = new Field68C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        if (StringUtils.isNotEmpty((String)this.getComponent4())) {
            result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        }
        result.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent6()));
        result.append("\r\n");
        result.append(StringUtils.trimToEmpty((String)this.getComponent7()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent8()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent9()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent10()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent11()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent12()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("68C", value);
    }

    public static Tag emptyTag() {
        return new Tag("68C", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getBuySellIndicator() {
        return this.getComponent(1);
    }

    public Field68C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field68C setBuySellIndicator(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getCallPutIndicator() {
        return this.getComponent(2);
    }

    public Field68C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field68C setCallPutIndicator(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getStyleIndicator() {
        return this.getComponent(3);
    }

    public Field68C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field68C setStyleIndicator(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(4));
    }

    public String getDateContractAgreed() {
        return this.getComponent(4);
    }

    public Calendar getDateContractAgreedAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(4));
    }

    public Field68C setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field68C setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getDate2(component4));
        return this;
    }

    public Field68C setDateContractAgreed(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field68C setDateContractAgreed(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public String getUnit() {
        return this.getComponent(5);
    }

    public Field68C setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field68C setUnit(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public String getAmountOfTheUnderlyingCommodity() {
        return this.getComponent(6);
    }

    public Number getAmountOfTheUnderlyingCommodityAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public Field68C setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field68C setComponent6(Number component6) {
        this.setComponent(6, SwiftFormatUtils.getNumber(component6));
        return this;
    }

    public Field68C setAmountOfTheUnderlyingCommodity(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field68C setAmountOfTheUnderlyingCommodity(Number component6) {
        this.setComponent6(component6);
        return this;
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    public Currency getComponent7AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(7));
    }

    public String getStrikePricePerUnitCurrency() {
        return this.getComponent(7);
    }

    public Currency getStrikePricePerUnitCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(7));
    }

    public Field68C setComponent7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field68C setComponent7(Currency component7) {
        this.setComponent(7, SwiftFormatUtils.getCurrency(component7));
        return this;
    }

    public Field68C setStrikePricePerUnitCurrency(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field68C setStrikePricePerUnitCurrency(Currency component7) {
        this.setComponent7(component7);
        return this;
    }

    public String getComponent8() {
        return this.getComponent(8);
    }

    public Number getComponent8AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public String getStrikePricePerUnit() {
        return this.getComponent(8);
    }

    public Number getStrikePricePerUnitAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public Field68C setComponent8(String component8) {
        this.setComponent(8, component8);
        return this;
    }

    public Field68C setComponent8(Number component8) {
        this.setComponent(8, SwiftFormatUtils.getNumber(component8));
        return this;
    }

    public Field68C setStrikePricePerUnit(String component8) {
        this.setComponent(8, component8);
        return this;
    }

    public Field68C setStrikePricePerUnit(Number component8) {
        this.setComponent8(component8);
        return this;
    }

    public String getComponent9() {
        return this.getComponent(9);
    }

    public Currency getComponent9AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(9));
    }

    public String getPremiumPricePerUnitCurrency() {
        return this.getComponent(9);
    }

    public Currency getPremiumPricePerUnitCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(9));
    }

    public Field68C setComponent9(String component9) {
        this.setComponent(9, component9);
        return this;
    }

    public Field68C setComponent9(Currency component9) {
        this.setComponent(9, SwiftFormatUtils.getCurrency(component9));
        return this;
    }

    public Field68C setPremiumPricePerUnitCurrency(String component9) {
        this.setComponent(9, component9);
        return this;
    }

    public Field68C setPremiumPricePerUnitCurrency(Currency component9) {
        this.setComponent9(component9);
        return this;
    }

    public String getComponent10() {
        return this.getComponent(10);
    }

    public Number getComponent10AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(10));
    }

    public String getPremiumPricePerUnit() {
        return this.getComponent(10);
    }

    public Number getPremiumPricePerUnitAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(10));
    }

    public Field68C setComponent10(String component10) {
        this.setComponent(10, component10);
        return this;
    }

    public Field68C setComponent10(Number component10) {
        this.setComponent(10, SwiftFormatUtils.getNumber(component10));
        return this;
    }

    public Field68C setPremiumPricePerUnit(String component10) {
        this.setComponent(10, component10);
        return this;
    }

    public Field68C setPremiumPricePerUnit(Number component10) {
        this.setComponent10(component10);
        return this;
    }

    public String getComponent11() {
        return this.getComponent(11);
    }

    public Currency getComponent11AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(11));
    }

    public String getPremiumPaymentCurrency() {
        return this.getComponent(11);
    }

    public Currency getPremiumPaymentCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(11));
    }

    public Field68C setComponent11(String component11) {
        this.setComponent(11, component11);
        return this;
    }

    public Field68C setComponent11(Currency component11) {
        this.setComponent(11, SwiftFormatUtils.getCurrency(component11));
        return this;
    }

    public Field68C setPremiumPaymentCurrency(String component11) {
        this.setComponent(11, component11);
        return this;
    }

    public Field68C setPremiumPaymentCurrency(Currency component11) {
        this.setComponent11(component11);
        return this;
    }

    public String getComponent12() {
        return this.getComponent(12);
    }

    public Number getComponent12AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(12));
    }

    public String getPremiumPayment() {
        return this.getComponent(12);
    }

    public Number getPremiumPaymentAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(12));
    }

    public Field68C setComponent12(String component12) {
        this.setComponent(12, component12);
        return this;
    }

    public Field68C setComponent12(Number component12) {
        this.setComponent(12, SwiftFormatUtils.getNumber(component12));
        return this;
    }

    public Field68C setPremiumPayment(String component12) {
        this.setComponent(12, component12);
        return this;
    }

    public Field68C setPremiumPayment(Number component12) {
        this.setComponent12(component12);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(4)));
        return result;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "68C";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4a/4a/1a[<DATE2>]3!a<AMOUNT>15$<CUR><AMOUNT>15<CUR><AMOUNT>15<CUR><AMOUNT>15";
    }

    public static Field68C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("68C");
        if (t == null) {
            return null;
        }
        return new Field68C(t);
    }

    public static Field68C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field68C.get(msg.getBlock4());
    }

    public static List<Field68C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field68C.getAll(msg.getBlock4());
    }

    public static List<Field68C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("68C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field68C> result = new ArrayList<Field68C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field68C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 12;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field68C cp = Field68C.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field68C cp = Field68C.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field68C cp = Field68C.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        Format f;
        if (component < 1 || component > 12) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 68C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent6AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 7) {
            return this.getComponent(7);
        }
        if (component == 8) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent8AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 9) {
            return this.getComponent(9);
        }
        if (component == 10) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent10AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 11) {
            return this.getComponent(11);
        }
        if (component == 12) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent12AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Buy/Sell Indicator");
        result.add("Call/Put Indicator");
        result.add("Style Indicator");
        result.add("Date Contract Agreed");
        result.add("Unit");
        result.add("Amount Of The Underlying Commodity");
        result.add("Strike Price Per Unit Currency");
        result.add("Strike Price Per Unit");
        result.add("Premium Price Per Unit Currency");
        result.add("Premium Price Per Unit");
        result.add("Premium Payment Currency");
        result.add("Premium Payment");
        return result;
    }
}

