/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field69A
extends Field
implements Serializable,
DateContainer,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "69A";
    public static final String F_69A = "69A";
    public static final String PARSER_PATTERN = ":S//S/S";
    public static final String COMPONENTS_PATTERN = "SDD";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATE1 = 2;
    public static final Integer DATE2 = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field69A() {
        super(3);
    }

    public Field69A(String value) {
        super(value);
    }

    public Field69A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"69A")) {
            throw new IllegalArgumentException("cannot create field 69A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    public static Field69A newInstance(Field69A source) {
        Field69A cp = new Field69A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("//");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("69A", value);
    }

    public static Tag emptyTag() {
        return new Tag("69A", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field69A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field69A setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getDate1() {
        return this.getComponent(2);
    }

    public Calendar getDate1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public Field69A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field69A setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate4(component2));
        return this;
    }

    public Field69A setDate1(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field69A setDate1(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(3));
    }

    public String getDate2() {
        return this.getComponent(3);
    }

    public Calendar getDate2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(3));
    }

    public Field69A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field69A setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getDate4(component3));
        return this;
    }

    public Field69A setDate2(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field69A setDate2(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(2)));
        result.add(SwiftFormatUtils.getDate4(this.getComponent(3)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "69A";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<DATE4>/<DATE4>";
    }

    public static Field69A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("69A");
        if (t == null) {
            return null;
        }
        return new Field69A(t);
    }

    public static Field69A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field69A.get(msg.getBlock4());
    }

    public static List<Field69A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field69A.getAll(msg.getBlock4());
    }

    public static List<Field69A> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("69A");
        if (arr != null && arr.length > 0) {
            ArrayList<Field69A> result = new ArrayList<Field69A>(arr.length);
            for (Tag f : arr) {
                result.add(new Field69A(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 69A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Date1");
        result.add("Date2");
        return result;
    }
}

