/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field69B
extends Field
implements Serializable,
DateContainer,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "69B";
    public static final String F_69B = "69B";
    public static final String PARSER_PATTERN = ":S//<DATE4><TIME2>/<DATE4><TIME2>";
    public static final String COMPONENTS_PATTERN = "SDTDT";
    public static final Integer QUALIFIER = 1;
    public static final Integer START_DATE = 2;
    public static final Integer START_TIME = 3;
    public static final Integer END_DATE = 4;
    public static final Integer END_TIME = 5;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field69B() {
        super(5);
    }

    public Field69B(String value) {
        super(value);
    }

    public Field69B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"69B")) {
            throw new IllegalArgumentException("cannot create field 69B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        String toparse2 = SwiftParseUtils.getTokenFirst(toparse, "/");
        String toparse3 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        if (toparse2 != null) {
            if (toparse2.length() >= 8) {
                this.setComponent2(StringUtils.substring((String)toparse2, (int)0, (int)8));
            }
            if (toparse2.length() > 8) {
                this.setComponent3(StringUtils.substring((String)toparse2, (int)8));
            }
        }
        if (toparse3 != null) {
            if (toparse3.length() >= 8) {
                this.setComponent4(StringUtils.substring((String)toparse3, (int)0, (int)8));
            }
            if (toparse3.length() > 8) {
                this.setComponent5(StringUtils.substring((String)toparse3, (int)8));
            }
        }
    }

    public static Field69B newInstance(Field69B source) {
        Field69B cp = new Field69B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("//");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("69B", value);
    }

    public static Tag emptyTag() {
        return new Tag("69B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field69B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field69B setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getStartDate() {
        return this.getComponent(2);
    }

    public Calendar getStartDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public Field69B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field69B setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate4(component2));
        return this;
    }

    public Field69B setStartDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field69B setStartDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(3));
    }

    public String getStartTime() {
        return this.getComponent(3);
    }

    public Calendar getStartTimeAsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(3));
    }

    public Field69B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field69B setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime2(component3));
        return this;
    }

    public Field69B setStartTime(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field69B setStartTime(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(4));
    }

    public String getEndDate() {
        return this.getComponent(4);
    }

    public Calendar getEndDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(4));
    }

    public Field69B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field69B setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getDate4(component4));
        return this;
    }

    public Field69B setEndDate(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field69B setEndDate(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Calendar getComponent5AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(5));
    }

    public String getEndTime() {
        return this.getComponent(5);
    }

    public Calendar getEndTimeAsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(5));
    }

    public Field69B setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field69B setComponent5(Calendar component5) {
        this.setComponent(5, SwiftFormatUtils.getTime2(component5));
        return this;
    }

    public Field69B setEndTime(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field69B setEndTime(Calendar component5) {
        this.setComponent5(component5);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(2)));
        result.add(SwiftFormatUtils.getTime2(this.getComponent(3)));
        result.add(SwiftFormatUtils.getDate4(this.getComponent(4)));
        result.add(SwiftFormatUtils.getTime2(this.getComponent(5)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "69B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<DATE4><TIME2>/<DATE4><TIME2>";
    }

    public static Field69B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("69B");
        if (t == null) {
            return null;
        }
        return new Field69B(t);
    }

    public static Field69B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field69B.get(msg.getBlock4());
    }

    public static List<Field69B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field69B.getAll(msg.getBlock4());
    }

    public static List<Field69B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("69B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field69B> result = new ArrayList<Field69B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field69B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 69B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 4) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 5) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent5AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Start Date");
        result.add("Start Time");
        result.add("End Date");
        result.add("End Time");
        return result;
    }
}

