/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field90A
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90A";
    public static final String F_90A = "90A";
    public static final String PARSER_PATTERN = ":S//S/[S]N";
    public static final String COMPONENTS_PATTERN = "SSSN";
    public static final Integer QUALIFIER = 1;
    public static final Integer PERCENTAGE_TYPE_CODE = 2;
    public static final Integer SIGN = 3;
    public static final Integer PRICE = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field90A() {
        super(4);
    }

    public Field90A(String value) {
        super(value);
    }

    public Field90A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"90A")) {
            throw new IllegalArgumentException("cannot create field 90A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(toparse2));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    public static Field90A newInstance(Field90A source) {
        Field90A cp = new Field90A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("//");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("90A", value);
    }

    public static Tag emptyTag() {
        return new Tag("90A", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field90A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90A setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getPercentageTypeCode() {
        return this.getComponent(2);
    }

    public Field90A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90A setPercentageTypeCode(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getSign() {
        return this.getComponent(3);
    }

    public Field90A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90A setSign(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getPrice() {
        return this.getComponent(4);
    }

    public Number getPriceAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field90A setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90A setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field90A setPrice(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90A setPrice(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "90A";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//4!c/[<N>]<AMOUNT>15";
    }

    public static Field90A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("90A");
        if (t == null) {
            return null;
        }
        return new Field90A(t);
    }

    public static Field90A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field90A.get(msg.getBlock4());
    }

    public static List<Field90A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field90A.getAll(msg.getBlock4());
    }

    public static List<Field90A> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("90A");
        if (arr != null && arr.length > 0) {
            ArrayList<Field90A> result = new ArrayList<Field90A>(arr.length);
            for (Tag f : arr) {
                result.add(new Field90A(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 90A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Percentage Type Code");
        result.add("Sign");
        result.add("Price");
        return result;
    }
}

