/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field92P
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92P";
    public static final String F_92P = "92P";
    public static final String PARSER_PATTERN = ":S//N";
    public static final String COMPONENTS_PATTERN = "SN";
    public static final Integer QUALIFIER = 1;
    public static final Integer AMOUNT = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field92P() {
        super(2);
    }

    public Field92P(String value) {
        super(value);
    }

    public Field92P(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"92P")) {
            throw new IllegalArgumentException("cannot create field 92P from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    public static Field92P newInstance(Field92P source) {
        Field92P cp = new Field92P();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("//");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("92P", value);
    }

    public static Tag emptyTag() {
        return new Tag("92P", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field92P setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92P setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getAmount() {
        return this.getComponent(2);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field92P setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92P setComponent2(Number component2) {
        this.setComponent(2, SwiftFormatUtils.getNumber(component2));
        return this;
    }

    public Field92P setAmount(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92P setAmount(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "92P";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<AMOUNT>15";
    }

    public static Field92P get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92P");
        if (t == null) {
            return null;
        }
        return new Field92P(t);
    }

    public static Field92P get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92P.get(msg.getBlock4());
    }

    public static List<Field92P> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92P.getAll(msg.getBlock4());
    }

    public static List<Field92P> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("92P");
        if (arr != null && arr.length > 0) {
            ArrayList<Field92P> result = new ArrayList<Field92P>(arr.length);
            for (Tag f : arr) {
                result.add(new Field92P(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92P");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Amount");
        return result;
    }
}

