/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field94B
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "94B";
    public static final String F_94B = "94B";
    public static final String PARSER_PATTERN = ":S/[S]/S[/S]";
    public static final String COMPONENTS_PATTERN = "SSSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer PLACE_CODE = 3;
    public static final Integer NARRATIVE = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 3;

    public Field94B() {
        super(4);
    }

    public Field94B(String value) {
        super(value);
    }

    public Field94B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"94B")) {
            throw new IllegalArgumentException("cannot create field 94B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        this.setComponent3(SwiftParseUtils.getTokenThird(value, "/"));
        this.setComponent4(SwiftParseUtils.getTokenForthLast(value, "/"));
    }

    public static Field94B newInstance(Field94B source) {
        Field94B cp = new Field94B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("/");
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        if (StringUtils.isNotEmpty((String)this.getComponent4())) {
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("94B", value);
    }

    public static Tag emptyTag() {
        return new Tag("94B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field94B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field94B setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent(2);
    }

    public Field94B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field94B setDataSourceScheme(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getPlaceCode() {
        return this.getComponent(3);
    }

    public Field94B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field94B setPlaceCode(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public String getNarrative() {
        return this.getComponent(4);
    }

    public Field94B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field94B setNarrative(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "94B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c/[8c]/4!c[/30x]";
    }

    public static Field94B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("94B");
        if (t == null) {
            return null;
        }
        return new Field94B(t);
    }

    public static Field94B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field94B.get(msg.getBlock4());
    }

    public static List<Field94B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field94B.getAll(msg.getBlock4());
    }

    public static List<Field94B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("94B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field94B> result = new ArrayList<Field94B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field94B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 94B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Place Code");
        result.add("Narrative");
        return result;
    }
}

