/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field95S
extends Field
implements Serializable,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "95S";
    public static final String F_95S = "95S";
    public static final String PARSER_PATTERN = ":S/[S]/S/S/S";
    public static final String COMPONENTS_PATTERN = "SSSKS";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer TYPE_OF_ID = 3;
    public static final Integer COUNTRY_CODE = 4;
    public static final Integer ALTERNATE_ID = 5;
    public static final Integer CONDITIONAL_QUALIFIER = 3;

    public Field95S() {
        super(5);
    }

    public Field95S(String value) {
        super(value);
    }

    public Field95S(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"95S")) {
            throw new IllegalArgumentException("cannot create field 95S from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        this.setComponent3(SwiftParseUtils.getTokenThird(value, "/"));
        String toparse = SwiftParseUtils.getTokenForthLast(value, "/");
        this.setComponent4(SwiftParseUtils.getTokenFirst(toparse, "/"));
        this.setComponent5(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
    }

    public static Field95S newInstance(Field95S source) {
        Field95S cp = new Field95S();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("/");
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("95S", value);
    }

    public static Tag emptyTag() {
        return new Tag("95S", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field95S setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field95S setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent(2);
    }

    public Field95S setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field95S setDataSourceScheme(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getTypeOfID() {
        return this.getComponent(3);
    }

    public Field95S setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field95S setTypeOfID(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getCountryCode() {
        return this.getComponent(4);
    }

    public Field95S setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field95S setCountryCode(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public String getAlternateID() {
        return this.getComponent(5);
    }

    public Field95S setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field95S setAlternateID(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return this.getComponent2();
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "95S";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c/[8c]/4!c/<CC>/30x";
    }

    public static Field95S get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("95S");
        if (t == null) {
            return null;
        }
        return new Field95S(t);
    }

    public static Field95S get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field95S.get(msg.getBlock4());
    }

    public static List<Field95S> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field95S.getAll(msg.getBlock4());
    }

    public static List<Field95S> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("95S");
        if (arr != null && arr.length > 0) {
            ArrayList<Field95S> result = new ArrayList<Field95S>(arr.length);
            for (Tag f : arr) {
                result.add(new Field95S(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 95S");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Type Of ID");
        result.add("Country Code");
        result.add("Alternate ID");
        return result;
    }
}

