/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field98J
extends Field
implements Serializable,
DateContainer,
BICContainer,
GenericField {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "98J";
    public static final String F_98J = "98J";
    public static final String PARSER_PATTERN = ":S//S//<DATE4><TIME2>";
    public static final String COMPONENTS_PATTERN = "SBDT";
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field98J() {
        super(4);
    }

    public Field98J(String value) {
        super(value);
    }

    public Field98J(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"98J")) {
            throw new IllegalArgumentException("cannot create field 98J from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "//"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "//");
        if (toparse2 != null) {
            if (toparse2.length() >= 8) {
                this.setComponent3(StringUtils.substring((String)toparse2, (int)0, (int)8));
            }
            if (toparse2.length() > 8) {
                this.setComponent4(StringUtils.substring((String)toparse2, (int)8));
            }
        }
    }

    public static Field98J newInstance(Field98J source) {
        Field98J cp = new Field98J();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("//");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append("//");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("98J", value);
    }

    public static Tag emptyTag() {
        return new Tag("98J", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public Field98J setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public Field98J setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98J setComponent2(BIC component2) {
        this.setComponent(2, SwiftFormatUtils.getBIC(component2));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(3));
    }

    public Field98J setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98J setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getDate4(component3));
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(4));
    }

    public Field98J setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98J setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime2(component4));
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(3)));
        result.add(SwiftFormatUtils.getTime2(this.getComponent(4)));
        return result;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> result = new ArrayList<BIC>();
        result.add(SwiftFormatUtils.getBIC(this.getComponent(2)));
        return result;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getComponent(2));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "98J";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<BIC>//<DATE4><TIME2>";
    }

    public static Field98J get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("98J");
        if (t == null) {
            return null;
        }
        return new Field98J(t);
    }

    public static Field98J get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field98J.get(msg.getBlock4());
    }

    public static List<Field98J> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field98J.getAll(msg.getBlock4());
    }

    public static List<Field98J> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("98J");
        if (arr != null && arr.length > 0) {
            ArrayList<Field98J> result = new ArrayList<Field98J>(arr.length);
            for (Tag f : arr) {
                result.add(new Field98J(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 98J");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 4) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        return result;
    }
}

