/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field206;
import com.prowidesoftware.swift.model.field.Field339;
import com.prowidesoftware.swift.model.field.Field344;
import com.prowidesoftware.swift.model.field.Field345;
import com.prowidesoftware.swift.model.field.Field346;
import com.prowidesoftware.swift.model.field.Field347;
import com.prowidesoftware.swift.model.field.Field348;
import com.prowidesoftware.swift.model.field.Field349;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT047
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT047.class.getName());
    public static final String NAME = "047";
    @Deprecated
    public static final String _0 = "0";
    @Deprecated
    public static final String _1 = "1";
    @Deprecated
    public static final String L = "L";
    @Deprecated
    public static final String N = "N";
    @Deprecated
    public static final String O = "O";
    @Deprecated
    public static final String S = "S";
    @Deprecated
    public static final String U = "U";
    @Deprecated
    public static final String Y = "Y";

    public MT047(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT047(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT047 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT047(m.message());
    }

    public MT047() {
        this("TESTUS00", "TESTUS00");
    }

    public MT047(String sender, String receiver) {
        super(47, sender, receiver);
    }

    @Deprecated
    public MT047(int messageType, String sender, String receiver) {
        super(47, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT047(int, String, String)", "Use the constructor MT047(sender, receiver) instead.");
    }

    public MT047(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT047.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT047 object from FIN content with a Service Message. Check if the MT047 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT047 object from FIN content with message type " + param.getType());
        }
    }

    public static MT047 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT047(fin);
    }

    public MT047(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT047 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT047(stream);
    }

    public MT047(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT047 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT047(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT047 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT047 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT047 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field206 getField206() {
        Tag t = this.tag("206");
        if (t != null) {
            return new Field206(t.getValue());
        }
        return null;
    }

    public Field348 getField348() {
        Tag t = this.tag("348");
        if (t != null) {
            return new Field348(t.getValue());
        }
        return null;
    }

    public List<Field339> getField339() {
        ArrayList<Field339> result = new ArrayList<Field339>();
        Tag[] tags = this.tags("339");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field339(tags[i].getValue()));
        }
        return result;
    }

    public List<Field349> getField349() {
        ArrayList<Field349> result = new ArrayList<Field349>();
        Tag[] tags = this.tags("349");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field349(tags[i].getValue()));
        }
        return result;
    }

    public List<Field344> getField344() {
        ArrayList<Field344> result = new ArrayList<Field344>();
        Tag[] tags = this.tags("344");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field344(tags[i].getValue()));
        }
        return result;
    }

    public List<Field345> getField345() {
        ArrayList<Field345> result = new ArrayList<Field345>();
        Tag[] tags = this.tags("345");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field345(tags[i].getValue()));
        }
        return result;
    }

    public List<Field346> getField346() {
        ArrayList<Field346> result = new ArrayList<Field346>();
        Tag[] tags = this.tags("346");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field346(tags[i].getValue()));
        }
        return result;
    }

    public List<Field347> getField347() {
        ArrayList<Field347> result = new ArrayList<Field347>();
        Tag[] tags = this.tags("347");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field347(tags[i].getValue()));
        }
        return result;
    }
}

