/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt2xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field19;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field21D;
import com.prowidesoftware.swift.model.field.Field21E;
import com.prowidesoftware.swift.model.field.Field23E;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32J;
import com.prowidesoftware.swift.model.field.Field37J;
import com.prowidesoftware.swift.model.field.Field44A;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57C;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field58B;
import com.prowidesoftware.swift.model.field.Field71F;
import com.prowidesoftware.swift.model.field.Field71G;
import com.prowidesoftware.swift.model.field.Field71H;
import com.prowidesoftware.swift.model.field.Field71J;
import com.prowidesoftware.swift.model.field.Field71K;
import com.prowidesoftware.swift.model.field.Field71L;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT256
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT256.class.getName());
    public static final String NAME = "256";
    @Deprecated
    public static final String AMAM = "AMAM";
    @Deprecated
    public static final String AMTL = "AMTL";
    @Deprecated
    public static final String CLOS = "CLOS";
    @Deprecated
    public static final String COLN = "COLN";
    @Deprecated
    public static final String DRAW = "DRAW";
    @Deprecated
    public static final String DUPL = "DUPL";
    @Deprecated
    public static final String FRAU = "FRAU";
    @Deprecated
    public static final String FROZ = "FROZ";
    @Deprecated
    public static final String FRWD = "FRWD";
    @Deprecated
    public static final String INCH = "INCH";
    @Deprecated
    public static final String INSF = "INSF";
    @Deprecated
    public static final String INSI = "INSI";
    @Deprecated
    public static final String INVA = "INVA";
    @Deprecated
    public static final String NELI = "NELI";
    @Deprecated
    public static final String NMAT = "NMAT";
    @Deprecated
    public static final String OTHR = "OTHR";
    @Deprecated
    public static final String REVO = "REVO";
    @Deprecated
    public static final String STLD = "STLD";
    @Deprecated
    public static final String STOP = "STOP";

    public MT256(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT256(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT256 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT256(m.message());
    }

    public MT256() {
        this("TESTUS00", "TESTUS00");
    }

    public MT256(String sender, String receiver) {
        super(256, sender, receiver);
    }

    @Deprecated
    public MT256(int messageType, String sender, String receiver) {
        super(256, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT256(int, String, String)", "Use the constructor MT256(sender, receiver) instead.");
    }

    public MT256(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT256.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT256 object from FIN content with a Service Message. Check if the MT256 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT256 object from FIN content with message type " + param.getType());
        }
    }

    public static MT256 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT256(fin);
    }

    public MT256(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT256 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT256(stream);
    }

    public MT256(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT256 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT256(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT256 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT256 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT256 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field19 getField19() {
        Tag t = this.tag("19");
        if (t != null) {
            return new Field19(t.getValue());
        }
        return null;
    }

    public Field71J getField71J() {
        Tag t = this.tag("71J");
        if (t != null) {
            return new Field71J(t.getValue());
        }
        return null;
    }

    public Field71L getField71L() {
        Tag t = this.tag("71L");
        if (t != null) {
            return new Field71L(t.getValue());
        }
        return null;
    }

    public Field71K getField71K() {
        Tag t = this.tag("71K");
        if (t != null) {
            return new Field71K(t.getValue());
        }
        return null;
    }

    public Field57A getField57A() {
        Tag t = this.tag("57A");
        if (t != null) {
            return new Field57A(t.getValue());
        }
        return null;
    }

    public Field57C getField57C() {
        Tag t = this.tag("57C");
        if (t != null) {
            return new Field57C(t.getValue());
        }
        return null;
    }

    public Field57D getField57D() {
        Tag t = this.tag("57D");
        if (t != null) {
            return new Field57D(t.getValue());
        }
        return null;
    }

    public Field58B getField58B() {
        Tag t = this.tag("58B");
        if (t != null) {
            return new Field58B(t.getValue());
        }
        return null;
    }

    public List<Field44A> getField44A() {
        ArrayList<Field44A> result = new ArrayList<Field44A>();
        Tag[] tags = this.tags("44A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field44A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21(tags[i].getValue()));
        }
        return result;
    }

    public List<Field21D> getField21D() {
        ArrayList<Field21D> result = new ArrayList<Field21D>();
        Tag[] tags = this.tags("21D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field21E> getField21E() {
        ArrayList<Field21E> result = new ArrayList<Field21E>();
        Tag[] tags = this.tags("21E");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21E(tags[i].getValue()));
        }
        return result;
    }

    public List<Field23E> getField23E() {
        ArrayList<Field23E> result = new ArrayList<Field23E>();
        Tag[] tags = this.tags("23E");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field23E(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32J> getField32J() {
        ArrayList<Field32J> result = new ArrayList<Field32J>();
        Tag[] tags = this.tags("32J");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32J(tags[i].getValue()));
        }
        return result;
    }

    public List<Field37J> getField37J() {
        ArrayList<Field37J> result = new ArrayList<Field37J>();
        Tag[] tags = this.tags("37J");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field37J(tags[i].getValue()));
        }
        return result;
    }

    public List<Field71G> getField71G() {
        ArrayList<Field71G> result = new ArrayList<Field71G>();
        Tag[] tags = this.tags("71G");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field71G(tags[i].getValue()));
        }
        return result;
    }

    public List<Field71F> getField71F() {
        ArrayList<Field71F> result = new ArrayList<Field71F>();
        Tag[] tags = this.tags("71F");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field71F(tags[i].getValue()));
        }
        return result;
    }

    public List<Field71H> getField71H() {
        ArrayList<Field71H> result = new ArrayList<Field71H>();
        Tag[] tags = this.tags("71H");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field71H(tags[i].getValue()));
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            return new SequenceA(parentSequence.getSubBlockBeforeFirst("44A", false));
        }
        return null;
    }

    public List<SequenceB> getSequenceBList() {
        return MT256.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceB(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceC getSequenceC() {
        return this.getSequenceC(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceC getSequenceC(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockAfterLast("32A", true);
            if (content == null) {
                return null;
            }
            return new SequenceC(content);
        }
        return null;
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"44A"};
        protected static final String[] END = new String[]{"32J"};
        protected static final String[] TAIL = new String[]{"37J", "71G", "71F", "71H"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            return SequenceB.newInstance(0, 0, tags);
        }

        public static SequenceB newInstance(int start, int end, Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }
    }
}

