/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt3xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field11R;
import com.prowidesoftware.swift.model.field.Field11S;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field76;
import com.prowidesoftware.swift.model.field.Field77A;
import com.prowidesoftware.swift.model.field.Field79;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT396
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT396.class.getName());
    public static final String NAME = "396";

    public MT396(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT396(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT396 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT396(m.message());
    }

    public MT396() {
        this("TESTUS00", "TESTUS00");
    }

    public MT396(String sender, String receiver) {
        super(396, sender, receiver);
    }

    @Deprecated
    public MT396(int messageType, String sender, String receiver) {
        super(396, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT396(int, String, String)", "Use the constructor MT396(sender, receiver) instead.");
    }

    public MT396(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT396.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT396 object from FIN content with a Service Message. Check if the MT396 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT396 object from FIN content with message type " + param.getType());
        }
    }

    public static MT396 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT396(fin);
    }

    public MT396(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT396 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT396(stream);
    }

    public MT396(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT396 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT396(file);
    }

    public String getMessageType() {
        return NAME;
    }

    public MT396 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    public MT396 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    public MT396 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field76 getField76() {
        Tag t = this.tag("76");
        if (t != null) {
            return new Field76(t.getValue());
        }
        return null;
    }

    public Field77A getField77A() {
        Tag t = this.tag("77A");
        if (t != null) {
            return new Field77A(t.getValue());
        }
        return null;
    }

    public Field11R getField11R() {
        Tag t = this.tag("11R");
        if (t != null) {
            return new Field11R(t.getValue());
        }
        return null;
    }

    public Field11S getField11S() {
        Tag t = this.tag("11S");
        if (t != null) {
            return new Field11S(t.getValue());
        }
        return null;
    }

    public Field79 getField79() {
        Tag t = this.tag("79");
        if (t != null) {
            return new Field79(t.getValue());
        }
        return null;
    }
}

