/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT412
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT412.class.getName());
    public static final String NAME = "412";

    public MT412(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT412(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT412 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT412(m.message());
    }

    public MT412() {
        this("TESTUS00", "TESTUS00");
    }

    public MT412(String sender, String receiver) {
        super(412, sender, receiver);
    }

    @Deprecated
    public MT412(int messageType, String sender, String receiver) {
        super(412, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT412(int, String, String)", "Use the constructor MT412(sender, receiver) instead.");
    }

    public MT412(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT412.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT412 object from FIN content with a Service Message. Check if the MT412 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT412 object from FIN content with message type " + param.getType());
        }
    }

    public static MT412 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT412(fin);
    }

    public MT412(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT412 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT412(stream);
    }

    public MT412(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT412 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT412(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT412 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT412 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT412 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field20(tags[i].getValue()));
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32A> getField32A() {
        ArrayList<Field32A> result = new ArrayList<Field32A>();
        Tag[] tags = this.tags("32A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32A(tags[i].getValue()));
        }
        return result;
    }

    public List<SequenceA> getSequenceAList() {
        return MT412.getSequenceAList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA> getSequenceAList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceA> result = new ArrayList<SequenceA>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceA(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"32A"};
        protected static final String[] TAIL = new String[0];

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

