/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13A;
import com.prowidesoftware.swift.model.field.Field13B;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field22F;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field24B;
import com.prowidesoftware.swift.model.field.Field25D;
import com.prowidesoftware.swift.model.field.Field69A;
import com.prowidesoftware.swift.model.field.Field69B;
import com.prowidesoftware.swift.model.field.Field95L;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field97A;
import com.prowidesoftware.swift.model.field.Field97B;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.field.Field98C;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT549
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT549.class.getName());
    public static final String NAME = "549";
    @Deprecated
    public static final String ACOW = "ACOW";
    @Deprecated
    public static final String ADDINFO = "ADDINFO";
    @Deprecated
    public static final String AFFM = "AFFM";
    @Deprecated
    public static final String ALOC = "ALOC";
    @Deprecated
    public static final String ALTE = "ALTE";
    @Deprecated
    public static final String BASK = "BASK";
    @Deprecated
    public static final String BYSTAREA = "BYSTAREA";
    @Deprecated
    public static final String CACK = "CACK";
    @Deprecated
    public static final String CALL = "CALL";
    @Deprecated
    public static final String CANC = "CANC";
    @Deprecated
    public static final String CAND = "CAND";
    @Deprecated
    public static final String CANP = "CANP";
    @Deprecated
    public static final String CGEN = "CGEN";
    @Deprecated
    public static final String CODE = "CODE";
    @Deprecated
    public static final String CODU = "CODU";
    @Deprecated
    public static final String COMM = "COMM";
    @Deprecated
    public static final String COPY = "COPY";
    @Deprecated
    public static final String CORP = "CORP";
    @Deprecated
    public static final String CPRC = "CPRC";
    @Deprecated
    public static final String DEND = "DEND";
    @Deprecated
    public static final String DUPL = "DUPL";
    @Deprecated
    public static final String EPRC = "EPRC";
    @Deprecated
    public static final String ESTA = "ESTA";
    @Deprecated
    public static final String GENL = "GENL";
    @Deprecated
    public static final String INDX = "INDX";
    @Deprecated
    public static final String INMH = "INMH";
    @Deprecated
    public static final String IPRC = "IPRC";
    @Deprecated
    public static final String LINK = "LINK";
    @Deprecated
    public static final String LIST = "LIST";
    @Deprecated
    public static final String MAST = "MAST";
    @Deprecated
    public static final String MEOR = "MEOR";
    @Deprecated
    public static final String MERE = "MERE";
    @Deprecated
    public static final String MITI = "MITI";
    @Deprecated
    public static final String MOPN = "MOPN";
    @Deprecated
    public static final String MTCH = "MTCH";
    @Deprecated
    public static final String NAFI = "NAFI";
    @Deprecated
    public static final String NEWM = "NEWM";
    @Deprecated
    public static final String NMAT = "NMAT";
    @Deprecated
    public static final String PACK = "PACK";
    @Deprecated
    public static final String PCTI = "PCTI";
    @Deprecated
    public static final String PEND = "PEND";
    @Deprecated
    public static final String PENF = "PENF";
    @Deprecated
    public static final String POOL = "POOL";
    @Deprecated
    public static final String PPRC = "PPRC";
    @Deprecated
    public static final String PREV = "PREV";
    @Deprecated
    public static final String PROG = "PROG";
    @Deprecated
    public static final String REF = "REF";
    @Deprecated
    public static final String REJT = "REJT";
    @Deprecated
    public static final String RELA = "RELA";
    @Deprecated
    public static final String REPR = "REPR";
    @Deprecated
    public static final String REQU = "REQU";
    @Deprecated
    public static final String RERC = "RERC";
    @Deprecated
    public static final String REST = "REST";
    @Deprecated
    public static final String RPRC = "RPRC";
    @Deprecated
    public static final String SAFE = "SAFE";
    @Deprecated
    public static final String SEME = "SEME";
    @Deprecated
    public static final String SETT = "SETT";
    @Deprecated
    public static final String SFRE = "SFRE";
    @Deprecated
    public static final String STAT = "STAT";
    @Deprecated
    public static final String STBA = "STBA";
    @Deprecated
    public static final String STTY = "STTY";
    @Deprecated
    public static final String TPRC = "TPRC";
    @Deprecated
    public static final String TRRF = "TRRF";

    public MT549(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT549(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT549 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT549(m.message());
    }

    public MT549() {
        this("TESTUS00", "TESTUS00");
    }

    public MT549(String sender, String receiver) {
        super(549, sender, receiver);
    }

    @Deprecated
    public MT549(int messageType, String sender, String receiver) {
        super(549, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT549(int, String, String)", "Use the constructor MT549(sender, receiver) instead.");
    }

    public MT549(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT549.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT549 object from FIN content with a Service Message. Check if the MT549 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT549 object from FIN content with message type " + param.getType());
        }
    }

    public static MT549 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT549(fin);
    }

    public MT549(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT549 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT549(stream);
    }

    public MT549(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT549 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT549(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT549 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT549 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT549 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public Field98A getField98A() {
        Tag t = this.tag("98A");
        if (t != null) {
            return new Field98A(t.getValue());
        }
        return null;
    }

    public Field98C getField98C() {
        Tag t = this.tag("98C");
        if (t != null) {
            return new Field98C(t.getValue());
        }
        return null;
    }

    public Field69A getField69A() {
        Tag t = this.tag("69A");
        if (t != null) {
            return new Field69A(t.getValue());
        }
        return null;
    }

    public Field69B getField69B() {
        Tag t = this.tag("69B");
        if (t != null) {
            return new Field69B(t.getValue());
        }
        return null;
    }

    public Field97A getField97A() {
        Tag t = this.tag("97A");
        if (t != null) {
            return new Field97A(t.getValue());
        }
        return null;
    }

    public Field97B getField97B() {
        Tag t = this.tag("97B");
        if (t != null) {
            return new Field97B(t.getValue());
        }
        return null;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field95P(tags[i].getValue()));
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field95R(tags[i].getValue()));
        }
        return result;
    }

    public List<Field95L> getField95L() {
        ArrayList<Field95L> result = new ArrayList<Field95L>();
        Tag[] tags = this.tags("95L");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field95L(tags[i].getValue()));
        }
        return result;
    }

    public List<Field22F> getField22F() {
        ArrayList<Field22F> result = new ArrayList<Field22F>();
        Tag[] tags = this.tags("22F");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field22F(tags[i].getValue()));
        }
        return result;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field16R(tags[i].getValue()));
        }
        return result;
    }

    public List<Field13A> getField13A() {
        ArrayList<Field13A> result = new ArrayList<Field13A>();
        Tag[] tags = this.tags("13A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field13A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field13B> getField13B() {
        ArrayList<Field13B> result = new ArrayList<Field13B>();
        Tag[] tags = this.tags("13B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field13B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field20C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field16S(tags[i].getValue()));
        }
        return result;
    }

    public List<Field25D> getField25D() {
        ArrayList<Field25D> result = new ArrayList<Field25D>();
        Tag[] tags = this.tags("25D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field25D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field24B> getField24B() {
        ArrayList<Field24B> result = new ArrayList<Field24B>();
        Tag[] tags = this.tags("24B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field24B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field95Q(tags[i].getValue()));
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        s.setTags(parentSequence.getSubBlock(GENL).getTags());
        return s;
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT549.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks = parentSequence.getSubBlocks(LINK);
        if (blocks != null && !blocks.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA1 s = new SequenceA1();
                s.setTags(b.getSubBlock(LINK).getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceB> getSequenceBList() {
        return MT549.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks = parentSequence.getSubBlocks(BYSTAREA);
        if (blocks != null && !blocks.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB s = new SequenceB();
                s.setTags(b.getSubBlock(BYSTAREA).getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceC> getSequenceCList() {
        return MT549.getSequenceCList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC> getSequenceCList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks = parentSequence.getSubBlocks(REF);
        if (blocks != null && !blocks.isEmpty()) {
            ArrayList<SequenceC> result = new ArrayList<SequenceC>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC s = new SequenceC();
                s.setTags(b.getSubBlock(REF).getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceD getSequenceD() {
        return new SequenceD(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceD getSequenceD(SwiftTagListBlock parentSequence) {
        SequenceD s = new SequenceD();
        s.setTags(parentSequence.getSubBlock(ADDINFO).getTags());
        return s;
    }

    public static class SequenceD
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "ADDINFO";
        public static final Tag START_TAG = new Tag("16R", "ADDINFO");
        public static final Tag END_TAG = new Tag("16S", "ADDINFO");

        private SequenceD() {
            super(new ArrayList<Tag>());
        }

        private SequenceD(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceD newInstance(Tag ... tags) {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceD newInstance() {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceD newInstance(SwiftTagListBlock ... sequences) {
            SequenceD result = new SequenceD();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceD(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock("ADDINFO").getTags());
            }
        }
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "REF";
        public static final Tag START_TAG = new Tag("16R", "REF");
        public static final Tag END_TAG = new Tag("16S", "REF");

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock("REF").getTags());
            }
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "BYSTAREA";
        public static final Tag START_TAG = new Tag("16R", "BYSTAREA");
        public static final Tag END_TAG = new Tag("16S", "BYSTAREA");

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock("BYSTAREA").getTags());
            }
        }
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance() {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock("LINK").getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock("GENL").getTags());
            }
        }
    }
}

