/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field28;
import com.prowidesoftware.swift.model.field.Field35F;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT579
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT579.class.getName());
    public static final String NAME = "579";

    public MT579(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT579(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT579 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT579(m.message());
    }

    public MT579() {
        this("TESTUS00", "TESTUS00");
    }

    public MT579(String sender, String receiver) {
        super(579, sender, receiver);
    }

    @Deprecated
    public MT579(int messageType, String sender, String receiver) {
        super(579, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT579(int, String, String)", "Use the constructor MT579(sender, receiver) instead.");
    }

    public MT579(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT579.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT579 object from FIN content with a Service Message. Check if the MT579 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT579 object from FIN content with message type " + param.getType());
        }
    }

    public static MT579 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT579(fin);
    }

    public MT579(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT579 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT579(stream);
    }

    public MT579(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT579 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT579(file);
    }

    public String getMessageType() {
        return NAME;
    }

    public MT579 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    public MT579 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    public MT579 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field28 getField28() {
        Tag t = this.tag("28");
        if (t != null) {
            return new Field28(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field35F getField35F() {
        Tag t = this.tag("35F");
        if (t != null) {
            return new Field35F(t.getValue());
        }
        return null;
    }
}

