/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt6xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26N;
import com.prowidesoftware.swift.model.field.Field26P;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field29A;
import com.prowidesoftware.swift.model.field.Field29B;
import com.prowidesoftware.swift.model.field.Field31F;
import com.prowidesoftware.swift.model.field.Field31R;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field32E;
import com.prowidesoftware.swift.model.field.Field32P;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field33P;
import com.prowidesoftware.swift.model.field.Field33R;
import com.prowidesoftware.swift.model.field.Field34P;
import com.prowidesoftware.swift.model.field.Field34R;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57B;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field71C;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field88D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT643
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT643.class.getName());
    public static final String NAME = "643";

    public MT643(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT643(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT643 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT643(m.message());
    }

    public MT643() {
        this("TESTUS00", "TESTUS00");
    }

    public MT643(String sender, String receiver) {
        super(643, sender, receiver);
    }

    @Deprecated
    public MT643(int messageType, String sender, String receiver) {
        super(643, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT643(int, String, String)", "Use the constructor MT643(sender, receiver) instead.");
    }

    public MT643(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT643.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT643 object from FIN content with a Service Message. Check if the MT643 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT643 object from FIN content with message type " + param.getType());
        }
    }

    public static MT643 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT643(fin);
    }

    public MT643(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT643 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT643(stream);
    }

    public MT643(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT643 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT643(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT643 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT643 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT643 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field29A getField29A() {
        Tag t = this.tag("29A");
        if (t != null) {
            return new Field29A(t.getValue());
        }
        return null;
    }

    public Field29B getField29B() {
        Tag t = this.tag("29B");
        if (t != null) {
            return new Field29B(t.getValue());
        }
        return null;
    }

    public Field88D getField88D() {
        Tag t = this.tag("88D");
        if (t != null) {
            return new Field88D(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public List<Field26P> getField26P() {
        ArrayList<Field26P> result = new ArrayList<Field26P>();
        Tag[] tags = this.tags("26P");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field26P(tags[i].getValue()));
        }
        return result;
    }

    public List<Field31F> getField31F() {
        ArrayList<Field31F> result = new ArrayList<Field31F>();
        Tag[] tags = this.tags("31F");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field31F(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32P> getField32P() {
        ArrayList<Field32P> result = new ArrayList<Field32P>();
        Tag[] tags = this.tags("32P");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32P(tags[i].getValue()));
        }
        return result;
    }

    public List<Field33P> getField33P() {
        ArrayList<Field33P> result = new ArrayList<Field33P>();
        Tag[] tags = this.tags("33P");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field33P(tags[i].getValue()));
        }
        return result;
    }

    public List<Field33R> getField33R() {
        ArrayList<Field33R> result = new ArrayList<Field33R>();
        Tag[] tags = this.tags("33R");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field33R(tags[i].getValue()));
        }
        return result;
    }

    public List<Field71C> getField71C() {
        ArrayList<Field71C> result = new ArrayList<Field71C>();
        Tag[] tags = this.tags("71C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field71C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field34P> getField34P() {
        ArrayList<Field34P> result = new ArrayList<Field34P>();
        Tag[] tags = this.tags("34P");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field34P(tags[i].getValue()));
        }
        return result;
    }

    public List<Field34R> getField34R() {
        ArrayList<Field34R> result = new ArrayList<Field34R>();
        Tag[] tags = this.tags("34R");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field34R(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57A> getField57A() {
        ArrayList<Field57A> result = new ArrayList<Field57A>();
        Tag[] tags = this.tags("57A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57B> getField57B() {
        ArrayList<Field57B> result = new ArrayList<Field57B>();
        Tag[] tags = this.tags("57B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field57D> getField57D() {
        ArrayList<Field57D> result = new ArrayList<Field57D>();
        Tag[] tags = this.tags("57D");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field57D(tags[i].getValue()));
        }
        return result;
    }

    public List<Field72> getField72() {
        ArrayList<Field72> result = new ArrayList<Field72>();
        Tag[] tags = this.tags("72");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field72(tags[i].getValue()));
        }
        return result;
    }

    public List<Field26N> getField26N() {
        ArrayList<Field26N> result = new ArrayList<Field26N>();
        Tag[] tags = this.tags("26N");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field26N(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32E> getField32E() {
        ArrayList<Field32E> result = new ArrayList<Field32E>();
        Tag[] tags = this.tags("32E");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32E(tags[i].getValue()));
        }
        return result;
    }

    public List<Field31R> getField31R() {
        ArrayList<Field31R> result = new ArrayList<Field31R>();
        Tag[] tags = this.tags("31R");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field31R(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field33B> getField33B() {
        ArrayList<Field33B> result = new ArrayList<Field33B>();
        Tag[] tags = this.tags("33B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field33B(tags[i].getValue()));
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceA();
            }
            return new SequenceA(content);
        }
        return null;
    }

    public List<SequenceB> getSequenceBList() {
        return MT643.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceB(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceC> getSequenceCList() {
        return MT643.getSequenceCList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC> getSequenceCList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceC> result = new ArrayList<SequenceC>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceC.START, SequenceC.END, SequenceC.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceC(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"26N"};
        protected static final String[] END = new String[]{"33B"};
        protected static final String[] TAIL = new String[]{"57A", "57B", "57D", "72"};

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            return SequenceC.newInstance(0, 0, tags);
        }

        public static SequenceC newInstance(int start, int end, Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"26P"};
        protected static final String[] END = new String[]{"33P", "33R"};
        protected static final String[] TAIL = new String[]{"71C", "34P", "34R", "57A", "57B", "57D", "72"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            return SequenceB.newInstance(0, 0, tags);
        }

        public static SequenceB newInstance(int start, int end, Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"32A"};
        protected static final String[] TAIL = new String[0];

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

