/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field40C;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field77C;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT760
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT760.class.getName());
    public static final String NAME = "760";
    @Deprecated
    public static final String ISPR = "ISPR";
    @Deprecated
    public static final String NONE = "NONE";
    @Deprecated
    public static final String OTHR = "OTHR";
    @Deprecated
    public static final String URDG = "URDG";

    public MT760(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT760(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT760 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT760(m.message());
    }

    public MT760() {
        this("TESTUS00", "TESTUS00");
    }

    public MT760(String sender, String receiver) {
        super(760, sender, receiver);
    }

    @Deprecated
    public MT760(int messageType, String sender, String receiver) {
        super(760, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT760(int, String, String)", "Use the constructor MT760(sender, receiver) instead.");
    }

    public MT760(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT760.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT760 object from FIN content with a Service Message. Check if the MT760 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT760 object from FIN content with message type " + param.getType());
        }
    }

    public static MT760 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT760(fin);
    }

    public MT760(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT760 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT760(stream);
    }

    public MT760(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT760 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT760(file);
    }

    public String getMessageType() {
        return NAME;
    }

    public MT760 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    public MT760 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    public MT760 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field40C getField40C() {
        Tag t = this.tag("40C");
        if (t != null) {
            return new Field40C(t.getValue());
        }
        return null;
    }

    public Field77C getField77C() {
        Tag t = this.tag("77C");
        if (t != null) {
            return new Field77C(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

