/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field12;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21A;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field27A;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field40C;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field77C;
import com.prowidesoftware.swift.model.field.Field77E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT798_760
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT798_760.class.getName());
    public static final String NAME = "798_760";

    public MT798_760(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT798_760(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT798_760 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT798_760(m.message());
    }

    public MT798_760() {
        this("TESTUS00", "TESTUS00");
    }

    public MT798_760(String sender, String receiver) {
        super(798, sender, receiver);
    }

    @Deprecated
    public MT798_760(int messageType, String sender, String receiver) {
        super(798, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT798_760(int, String, String)", "Use the constructor MT798_760(sender, receiver) instead.");
    }

    public MT798_760(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT798_760.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT798_760 object from FIN content with a Service Message. Check if the MT798_760 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT798_760 object from FIN content with message type " + param.getType());
        }
    }

    public static MT798_760 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT798_760(fin);
    }

    public MT798_760(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT798_760 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT798_760(stream);
    }

    public MT798_760(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT798_760 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT798_760(file);
    }

    @Override
    public String getMessageType() {
        return "798";
    }

    @Override
    public MT798_760 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT798_760 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT798_760 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field12 getField12() {
        Tag t = this.tag("12");
        if (t != null) {
            return new Field12(t.getValue());
        }
        return null;
    }

    public Field77E getField77E() {
        Tag t = this.tag("77E");
        if (t != null) {
            return new Field77E(t.getValue());
        }
        return null;
    }

    public Field27A getField27A() {
        Tag t = this.tag("27A");
        if (t != null) {
            return new Field27A(t.getValue());
        }
        return null;
    }

    public Field21A getField21A() {
        Tag t = this.tag("21A");
        if (t != null) {
            return new Field21A(t.getValue());
        }
        return null;
    }

    public Field27 getField27() {
        Tag t = this.tag("27");
        if (t != null) {
            return new Field27(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field40C getField40C() {
        Tag t = this.tag("40C");
        if (t != null) {
            return new Field40C(t.getValue());
        }
        return null;
    }

    public Field77C getField77C() {
        Tag t = this.tag("77C");
        if (t != null) {
            return new Field77C(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field20(tags[i].getValue()));
        }
        return result;
    }
}

