/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt8xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field16A;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26A;
import com.prowidesoftware.swift.model.field.Field28;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field34B;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field51C;
import com.prowidesoftware.swift.model.field.Field73;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT801
extends AbstractMT
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT801.class.getName());
    public static final String NAME = "801";

    public MT801(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT801(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT801 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT801(m.message());
    }

    public MT801() {
        this("TESTUS00", "TESTUS00");
    }

    public MT801(String sender, String receiver) {
        super(801, sender, receiver);
    }

    @Deprecated
    public MT801(int messageType, String sender, String receiver) {
        super(801, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT801(int, String, String)", "Use the constructor MT801(sender, receiver) instead.");
    }

    public MT801(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT801.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT801 object from FIN content with a Service Message. Check if the MT801 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT801 object from FIN content with message type " + param.getType());
        }
    }

    public static MT801 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT801(fin);
    }

    public MT801(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT801 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT801(stream);
    }

    public MT801(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT801 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT801(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT801 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT801 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT801 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field28 getField28() {
        Tag t = this.tag("28");
        if (t != null) {
            return new Field28(t.getValue());
        }
        return null;
    }

    public Field23 getField23() {
        Tag t = this.tag("23");
        if (t != null) {
            return new Field23(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field33B getField33B() {
        Tag t = this.tag("33B");
        if (t != null) {
            return new Field33B(t.getValue());
        }
        return null;
    }

    public Field73 getField73() {
        Tag t = this.tag("73");
        if (t != null) {
            return new Field73(t.getValue());
        }
        return null;
    }

    public List<Field51A> getField51A() {
        ArrayList<Field51A> result = new ArrayList<Field51A>();
        Tag[] tags = this.tags("51A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field51A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field51C> getField51C() {
        ArrayList<Field51C> result = new ArrayList<Field51C>();
        Tag[] tags = this.tags("51C");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field51C(tags[i].getValue()));
        }
        return result;
    }

    public List<Field26A> getField26A() {
        ArrayList<Field26A> result = new ArrayList<Field26A>();
        Tag[] tags = this.tags("26A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field26A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field34B> getField34B() {
        ArrayList<Field34B> result = new ArrayList<Field34B>();
        Tag[] tags = this.tags("34B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field34B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field16A> getField16A() {
        ArrayList<Field16A> result = new ArrayList<Field16A>();
        Tag[] tags = this.tags("16A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field16A(tags[i].getValue()));
        }
        return result;
    }

    public List<SequenceA> getSequenceAList() {
        return MT801.getSequenceAList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA> getSequenceAList(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceA> result = new ArrayList<SequenceA>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceA(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT801.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>();
            List<SwiftTagListBlock> bs = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceA1.START, SequenceA1.END, SequenceA1.TAIL);
            if (bs != null && !bs.isEmpty()) {
                for (SwiftTagListBlock s : bs) {
                    result.add(new SequenceA1(s));
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"23"};
        protected static final String[] END = new String[]{"33B"};
        protected static final String[] TAIL = new String[]{"73"};

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            return SequenceA1.newInstance(0, 0, tags);
        }

        public static SequenceA1 newInstance(int start, int end, Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"51A", "51C"};
        protected static final String[] END = new String[]{"16A"};
        protected static final String[] TAIL = new String[0];

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

