/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.MIR;
import com.prowidesoftware.swift.model.MOR;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class SwiftFormatUtils {
    private static final transient Logger log = Logger.getLogger(SwiftFormatUtils.class.getName());

    private SwiftFormatUtils() {
        throw new AssertionError();
    }

    public static Calendar getDate2(String strDate) {
        if (strDate != null && strDate.length() == 6) {
            return SwiftFormatUtils.getCalendar(strDate, "yyMMdd");
        }
        return null;
    }

    public static String getDate2(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "yyMMdd");
    }

    public static Calendar getDate1(String strDate) {
        if (strDate != null && strDate.length() == 4) {
            return SwiftFormatUtils.getCalendar(strDate, "MMdd");
        }
        return null;
    }

    public static final boolean isLeapYear() {
        return Calendar.getInstance().getActualMaximum(6) > 365;
    }

    public static final boolean isLeapYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        return cal.getActualMaximum(6) > 365;
    }

    public static String getDate1(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "MMdd");
    }

    public static Calendar getDate3(String strDate) {
        if (strDate != null && strDate.length() == 4) {
            return SwiftFormatUtils.getCalendar(strDate, "yyMM");
        }
        return null;
    }

    public static String getDate3(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "yyMM");
    }

    public static Calendar getDate4(String strDate) {
        if (strDate != null && strDate.length() == 8) {
            return SwiftFormatUtils.getCalendar(strDate, "yyyyMMdd");
        }
        return null;
    }

    public static String getDate4(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "yyyyMMdd");
    }

    public static Calendar getYear(String strDate) {
        if (strDate != null && strDate.length() == 4) {
            return SwiftFormatUtils.getCalendar(strDate, "yyyy");
        }
        return null;
    }

    public static String getYear(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "yyyy");
    }

    public static Number getNumber(String amount) {
        Number number = null;
        if (amount != null) {
            try {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setDecimalSeparator(',');
                DecimalFormat df = new DecimalFormat("00.##", symbols);
                df.setParseBigDecimal(true);
                number = df.parse(amount);
            }
            catch (ParseException e) {
                log.log(Level.WARNING, "Error parsing number", e);
            }
        }
        return number;
    }

    public static String getNumber(Number number) {
        if (number != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator(',');
            DecimalFormat df = new DecimalFormat("0.##########", symbols);
            df.setParseBigDecimal(true);
            df.setDecimalSeparatorAlwaysShown(true);
            String formatted = df.format(number);
            String result = StringUtils.replaceChars((String)formatted, (char)'.', (char)',');
            return result;
        }
        return null;
    }

    public static Calendar getHhmm(String hhmm) {
        if (hhmm != null && hhmm.length() == 4) {
            return SwiftFormatUtils.getCalendar(hhmm, "HHmm");
        }
        return null;
    }

    private static Calendar getCalendar(String value, String format) {
        if (value != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                sdf.setLenient(false);
                Date d = sdf.parse(value);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(d);
                return cal;
            }
            catch (ParseException e) {
                log.log(Level.WARNING, "Could not parse '" + value + "' with pattern '" + format + "'");
            }
        }
        return null;
    }

    private static String getCalendar(Calendar date, String format) {
        if (date != null) {
            return DateFormatUtils.format((Date)date.getTime(), (String)format);
        }
        return null;
    }

    public static Calendar getTime2(String hhmmss) {
        if (hhmmss != null && hhmmss.length() == 6) {
            return SwiftFormatUtils.getCalendar(hhmmss, "HHmmss");
        }
        return null;
    }

    public static String getTime2(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "HHmmss");
    }

    public static Calendar getTime3(String hhmmss) {
        if (hhmmss != null) {
            if (hhmmss.length() == 2) {
                return SwiftFormatUtils.getCalendar(hhmmss, "HH");
            }
            if (hhmmss.length() == 4) {
                return SwiftFormatUtils.getCalendar(hhmmss, "HHmm");
            }
        }
        return null;
    }

    public static String getTime3(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "HHmm");
    }

    public static Character getSign(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            return Character.valueOf(string.charAt(0));
        }
        return null;
    }

    public static Calendar getOffset(String string) {
        Calendar result = SwiftFormatUtils.getHhmm(string);
        return result;
    }

    public static String getOffset(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "HHmm");
    }

    public static Currency getCurrency(String code) {
        if (code != null) {
            return Currency.getInstance(code);
        }
        return null;
    }

    public static String getCurrency(Currency currency) {
        return currency.getCurrencyCode();
    }

    public static BIC getBIC(String code) {
        return new BIC(code);
    }

    public static String getBIC(BIC bic) {
        if (StringUtils.isBlank((String)bic.getBranch())) {
            return bic.getBic8();
        }
        return bic.getBic11();
    }

    public static Boolean getBoolean(String string) {
        if (StringUtils.equals((String)"Y", (String)string)) {
            return Boolean.TRUE;
        }
        if (StringUtils.equals((String)"N", (String)string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String getBoolean(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? "Y" : "N";
    }

    public static Calendar getDateTime(String strDate) {
        if (strDate != null && strDate.length() == 12) {
            return SwiftFormatUtils.getCalendar(strDate, "yyyyMMddHHmm");
        }
        return null;
    }

    public static String getDateTime(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "yyyyMMddHHmm");
    }

    public static Calendar getDateTimeShortYear(String strDate) {
        if (strDate != null && strDate.length() == 10) {
            return SwiftFormatUtils.getCalendar(strDate, "yyMMddHHmm");
        }
        return null;
    }

    public static String getDateTimeShortYear(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "yyMMddHHmm");
    }

    public static Calendar getDayTime(String strDate) {
        if (strDate != null && strDate.length() == 6) {
            return SwiftFormatUtils.getCalendar(strDate, "ddHHmm");
        }
        return null;
    }

    public static String getDayTime(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "ddHHmm");
    }

    public static Calendar getMonthDay(String strDate) {
        if (strDate != null && strDate.length() == 4) {
            return SwiftFormatUtils.getCalendar(strDate, "MMdd");
        }
        return null;
    }

    public static String getMonthDay(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "MMdd");
    }

    public static Calendar getHour(String strDate) {
        if (strDate != null && strDate.length() == 2) {
            return SwiftFormatUtils.getCalendar(strDate, "HH");
        }
        return null;
    }

    public static String getHour(Calendar date) {
        return SwiftFormatUtils.getCalendar(date, "HH");
    }

    public static MIR getMIR(String value) {
        if (value != null && value.length() == 28) {
            return new MIR(value);
        }
        return null;
    }

    public static String getMIR(MIR mir) {
        if (mir != null) {
            return mir.getMIR();
        }
        return null;
    }

    public static MOR getMOR(String value) {
        if (value != null && value.length() == 28) {
            return new MOR(value);
        }
        return null;
    }

    public static String getMOR(MOR mor) {
        if (mor != null) {
            return mor.getMOR();
        }
        return null;
    }

    public static boolean isCurrency(String string) {
        if (StringUtils.isNotBlank((String)string)) {
            try {
                return Currency.getInstance(string) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static int decimalsInAmount(String amountString) {
        if (StringUtils.isNotEmpty((String)amountString)) {
            String tail = StringUtils.trim((String)StringUtils.substringAfterLast((String)amountString, (String)","));
            return tail.length();
        }
        return 0;
    }

    public static int decimalsInAmount(BigDecimal amount) {
        BigDecimal d;
        BigDecimal result;
        if (amount != null && (result = (d = new BigDecimal(amount.toString())).subtract(d.setScale(0, RoundingMode.FLOOR)).movePointRight(d.scale())).intValue() != 0) {
            return result.toString().length();
        }
        return 0;
    }

    public static final LogicalTerminalAddress getLTAddress(String address) {
        return new LogicalTerminalAddress(address);
    }

    public static final String getLTAddress(LogicalTerminalAddress address) {
        return address.getSenderLogicalTerminalAddress();
    }
}

