/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import java.util.Objects;

public enum BicValidationResult {
    OK("The BIC code is valid"),
    INVALID_LENGTH("The BIC code must contain at least 8 characters with the institution (4), country (2) and location code (2)"),
    INVALID_INSTITUTION_LENGTH("The institution code must contain 4 characters and ${length} were found in ${found}"),
    INVALID_COUNTRY_LENGTH("The country code must contain 2 characters and ${length} were found in ${found}"),
    INVALID_LOCATION_LENGTH("The location code must contain 2 characters and ${length} were found in ${found}"),
    INVALID_BRANCH_LENGTH("The branch code must contain 3 characters and ${length} were found in ${found}"),
    INVALID_INSTITUTION_CHARSET("The institution code can only contain uppercase letters and ${found} was found"),
    INVALID_COUNTRY("Invalid country code ${found}"),
    INVALID_LOCATION_CHARSET("The location code can only contain uppercase letters or digits and ${found} was found"),
    INVALID_BRANCH_CHARSET("The branch code can only contain uppercase letters or digits and ${found} was found");

    private final String message;
    private String found;

    private BicValidationResult(String message) {
        this.message = message;
    }

    public String message() {
        String msg = this.message.replace("${found}", Objects.toString(this.found)).replace("${length}", this.found == null ? "-1" : String.valueOf(this.found.length()));
        return msg;
    }

    BicValidationResult setFound(String found) {
        this.found = found;
        return this;
    }
}

