/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.ResolverUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;

public class AmountResolver {
    private static final Logger log = Logger.getLogger(AmountResolver.class.getName());

    public static List<BigDecimal> amounts(Field f) {
        Validate.notNull((Object)f);
        List<String> values = ResolverUtils.findNonNullWantedType(f.typesPattern(), 'I', f.getComponents());
        ArrayList<BigDecimal> amounts = new ArrayList<BigDecimal>();
        for (String value : values) {
            BigDecimal bigDecimal = SwiftFormatUtils.getBigDecimal(value);
            if (bigDecimal == null) continue;
            amounts.add(bigDecimal);
        }
        return amounts;
    }

    public static BigDecimal amount(Field f) {
        Validate.notNull((Object)f);
        String value = ResolverUtils.findFirstWantedType(f.typesPattern(), 'I', f.getComponents());
        if (value != null) {
            return SwiftFormatUtils.getBigDecimal(value);
        }
        return null;
    }
}

