/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.ResolverUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class BICResolver {
    public static List<String> bicStrings(Field f) {
        Validate.notNull((Object)f);
        return ResolverUtils.findWantedType(f.typesPattern(), 'B', f.getComponents());
    }

    public static List<BIC> bics(Field f) {
        Validate.notNull((Object)f);
        List<String> values = ResolverUtils.findWantedType(f.typesPattern(), 'B', f.getComponents());
        ArrayList<BIC> bics = new ArrayList<BIC>();
        for (String value : values) {
            bics.add(value != null ? SwiftFormatUtils.getBIC(value) : (BIC)null);
        }
        return bics;
    }
}

