/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field11R
extends Field
implements Serializable,
DateContainer,
MultiLineField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "11R";
    public static final String F_11R = "11R";
    public static final String PARSER_PATTERN = "S$<DATE2>[$4!S6!S]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "MENN";
    public static final String TYPES_PATTERN = "MENN";
    public static final Integer MT_NUMBER = 1;
    @Deprecated
    public static final Integer MT = 1;
    public static final Integer DATE = 2;
    public static final Integer SESSION_NUMBER = 3;
    public static final Integer ISN = 4;

    public Field11R() {
        super(4);
    }

    public Field11R(String value) {
        super(value);
    }

    public Field11R(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"11R")) {
            throw new IllegalArgumentException("cannot create field 11R from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field11R newInstance(Field11R source) {
        Field11R cp = new Field11R();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("11R", value);
    }

    public static Tag emptyTag() {
        return new Tag("11R", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        this.setComponent1(lines.get(0));
        if (lines.size() > 1) {
            this.setComponent2(lines.get(1));
        }
        if (lines.size() > 2) {
            String toparse = lines.get(2);
            if (toparse != null && toparse.length() >= 4) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)0, (int)4));
                if (toparse.length() > 4) {
                    this.setComponent4(StringUtils.substring((String)toparse, (int)4));
                }
            } else {
                this.setComponent3(toparse);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("\r\n").append(this.getComponent2());
        }
        if (this.getComponent3() != null || this.getComponent4() != null) {
            result.append("\r\n");
            this.append(result, 3);
            this.append(result, 4);
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 11R");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            DateFormat f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "MENN";
    }

    @Override
    public final String typesPattern() {
        return "MENN";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<MT>$<DATE2>[$4!n6!n]";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("MT Number");
        result.add("Date");
        result.add("Session Number");
        result.add("ISN");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "mTNumber");
        result.put(2, "date");
        result.put(3, "sessionNumber");
        result.put(4, "iSN");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getMTNumber() {
        return this.getComponent1();
    }

    @Deprecated
    public String getMT() {
        return this.getMTNumber();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent2();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Long getComponent3AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        Long l = this.getComponent3AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getSessionNumber() {
        return this.getComponent3();
    }

    public Long getSessionNumberAsLong() {
        return this.getComponent3AsLong();
    }

    @Deprecated
    public Number getSessionNumberAsNumber() {
        return this.getComponent3AsNumber();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Long getComponent4AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(4));
    }

    @Deprecated
    public Number getComponent4AsNumber() {
        Long l = this.getComponent4AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getISN() {
        return this.getComponent4();
    }

    public Long getISNAsLong() {
        return this.getComponent4AsLong();
    }

    @Deprecated
    public Number getISNAsNumber() {
        return this.getComponent4AsNumber();
    }

    public Field11R setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field11R setMTNumber(String component1) {
        return this.setComponent1(component1);
    }

    @Deprecated
    public Field11R setMT(String component1) {
        return this.setMTNumber(component1);
    }

    public Field11R setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field11R setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field11R setDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field11R setDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field11R setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field11R setComponent3(Long component3) {
        this.setComponent(3, SwiftFormatUtils.getLong(component3));
        return this;
    }

    public Field11R setComponent3(Number component3) {
        if (component3 instanceof Long) {
            this.setComponent(3, SwiftFormatUtils.getLong((Long)component3));
        } else if (component3 instanceof BigInteger || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field11R setSessionNumber(String component3) {
        return this.setComponent3(component3);
    }

    public Field11R setSessionNumber(Long component3) {
        return this.setComponent3(component3);
    }

    public Field11R setSessionNumber(Number component3) {
        return this.setComponent3(component3);
    }

    public Field11R setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field11R setComponent4(Long component4) {
        this.setComponent(4, SwiftFormatUtils.getLong(component4));
        return this;
    }

    public Field11R setComponent4(Number component4) {
        if (component4 instanceof Long) {
            this.setComponent(4, SwiftFormatUtils.getLong((Long)component4));
        } else if (component4 instanceof BigInteger || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getLong(component4.longValue()));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getLong(component4.longValue()));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field11R setISN(String component4) {
        return this.setComponent4(component4);
    }

    public Field11R setISN(Long component4) {
        return this.setComponent4(component4);
    }

    public Field11R setISN(Number component4) {
        return this.setComponent4(component4);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "11R";
    }

    public static Field11R get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("11R");
        if (t == null) {
            return null;
        }
        return new Field11R(t);
    }

    public static Field11R get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field11R.get(msg.getBlock4());
    }

    public static List<Field11R> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field11R.getAll(msg.getBlock4());
    }

    public static List<Field11R> getAll(SwiftTagListBlock block) {
        ArrayList<Field11R> result = new ArrayList<Field11R>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("11R");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field11R(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field11R cp = Field11R.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field11R cp = Field11R.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field11R cp = Field11R.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field11R fromJson(String json) {
        Field11R field = new Field11R();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("mT") != null) {
            field.setComponent1(jsonObject.get("mT").getAsString());
        }
        if (jsonObject.get("mTNumber") != null) {
            field.setComponent1(jsonObject.get("mTNumber").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("sessionNumber") != null) {
            field.setComponent3(jsonObject.get("sessionNumber").getAsString());
        }
        if (jsonObject.get("iSN") != null) {
            field.setComponent4(jsonObject.get("iSN").getAsString());
        }
        return field;
    }
}

