/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field334
extends Field
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "334";
    public static final String F_334 = "334";
    public static final String PARSER_PATTERN = "S<HHMM>";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SH";
    public static final String TYPES_PATTERN = "SH";
    public static final Integer REGION = 1;
    public static final Integer DELTA_TIME = 2;

    public Field334() {
        super(2);
    }

    public Field334(String value) {
        super(value);
    }

    public Field334(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"334")) {
            throw new IllegalArgumentException("cannot create field 334 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field334 newInstance(Field334 source) {
        Field334 cp = new Field334();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("334", value);
    }

    public static Tag emptyTag() {
        return new Tag("334", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null) {
            this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
            this.setComponent2(SwiftParseUtils.getNumericSuffix(value));
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 334");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "SH";
    }

    @Override
    public final String typesPattern() {
        return "SH";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "3!c<HHMM>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Region");
        result.add("Delta Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "region");
        result.put(2, "deltaTime");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getRegion() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getDeltaTime() {
        return this.getComponent2();
    }

    public Calendar getDeltaTimeAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public Field334 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field334 setRegion(String component1) {
        return this.setComponent1(component1);
    }

    public Field334 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field334 setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field334 setDeltaTime(String component2) {
        return this.setComponent2(component2);
    }

    public Field334 setDeltaTime(Calendar component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "334";
    }

    public static Field334 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("334");
        if (t == null) {
            return null;
        }
        return new Field334(t);
    }

    public static Field334 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field334.get(msg.getBlock4());
    }

    public static List<Field334> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field334.getAll(msg.getBlock4());
    }

    public static List<Field334> getAll(SwiftTagListBlock block) {
        ArrayList<Field334> result = new ArrayList<Field334>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("334");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field334(f));
            }
        }
        return result;
    }

    public static Field334 fromJson(String json) {
        Field334 field = new Field334();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("region") != null) {
            field.setComponent1(jsonObject.get("region").getAsString());
        }
        if (jsonObject.get("deltaTime") != null) {
            field.setComponent2(jsonObject.get("deltaTime").getAsString());
        }
        return field;
    }
}

