/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field98C
extends Field
implements Serializable,
DateContainer,
GenericField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "98C";
    public static final String F_98C = "98C";
    public static final String PARSER_PATTERN = ":S//<DATE4><TIME2>";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SDT";
    public static final String TYPES_PATTERN = "SDT";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATE = 2;
    public static final Integer TIME = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field98C() {
        super(3);
    }

    public Field98C(String value) {
        super(value);
    }

    public Field98C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"98C")) {
            throw new IllegalArgumentException("cannot create field 98C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field98C newInstance(Field98C source) {
        Field98C cp = new Field98C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("98C", value);
    }

    public static Tag emptyTag() {
        return new Tag("98C", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        if (toparse != null) {
            this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)8));
            this.setComponent3(StringUtils.substring((String)toparse, (int)8));
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 98C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "SDT";
    }

    @Override
    public final String typesPattern() {
        return "SDT";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<DATE4><TIME2>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Date");
        result.add("Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "date");
        result.put(3, "time");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent2();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(3));
    }

    public String getTime() {
        return this.getComponent3();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent3AsCalendar();
    }

    public Field98C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98C setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field98C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98C setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate4(component2));
        return this;
    }

    public Field98C setDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field98C setDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field98C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98C setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime2(component3));
        return this;
    }

    public Field98C setTime(String component3) {
        return this.setComponent3(component3);
    }

    public Field98C setTime(Calendar component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "98C";
    }

    public static Field98C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("98C");
        if (t == null) {
            return null;
        }
        return new Field98C(t);
    }

    public static Field98C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field98C.get(msg.getBlock4());
    }

    public static List<Field98C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field98C.getAll(msg.getBlock4());
    }

    public static List<Field98C> getAll(SwiftTagListBlock block) {
        ArrayList<Field98C> result = new ArrayList<Field98C>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("98C");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field98C(f));
            }
        }
        return result;
    }

    public static Field98C fromJson(String json) {
        Field98C field = new Field98C();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent3(jsonObject.get("time").getAsString());
        }
        return field;
    }
}

