/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.prowidesoftware.swift.model.field.Field;
import org.apache.commons.lang3.StringUtils;

class NarrativeContainerJsonUtils {
    NarrativeContainerJsonUtils() {
    }

    static void fromJson(JsonObject jsonObject, String json, Field field) {
        if (jsonObject.get("narrative") != null) {
            int numberOfNarrativesInJson = NarrativeContainerJsonUtils.countNarrativesInJson(json);
            if (numberOfNarrativesInJson > 1) {
                JsonObject jsonWithNarrativeGroup = NarrativeContainerJsonUtils.groupNarratives(json, numberOfNarrativesInJson);
                field.setComponent(1, jsonWithNarrativeGroup.get("narrative").getAsString());
            } else {
                field.setComponent(1, jsonObject.get("narrative").getAsString());
            }
        }
    }

    private static JsonObject groupNarratives(String json, int numberOfNarrativesInJson) {
        Gson gson = new Gson();
        JsonElement element = (JsonElement)gson.fromJson(json, JsonElement.class);
        JsonObject jsonObj = element.getAsJsonObject();
        String finalNarrativeValue = jsonObj.get("narrative").getAsString();
        for (int i = 2; i <= numberOfNarrativesInJson; ++i) {
            String currentNarrativeValue = jsonObj.get("narrative" + i).getAsString();
            finalNarrativeValue = finalNarrativeValue + currentNarrativeValue;
            jsonObj.remove("narrative" + i);
        }
        jsonObj.addProperty("narrative", finalNarrativeValue);
        return jsonObj;
    }

    private static int countNarrativesInJson(String json) {
        return StringUtils.countMatches((CharSequence)json, (CharSequence)"narrative");
    }
}

