/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.BitSet;

@StatelessCheck
public final class MissingDeprecatedCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY_ANNOTATION_MISSING_DEPRECATED = "annotation.missing.deprecated";
    public static final String MSG_KEY_JAVADOC_DUPLICATE_TAG = "javadoc.duplicateTag";
    private static final String DEPRECATED = "Deprecated";
    private static final String FQ_DEPRECATED = "java.lang.Deprecated";
    private static final BitSet TYPES_HASH_SET = TokenUtil.asBitSet(13, 5, 159, 158, 17, 165, 59);

    @Override
    public int[] getDefaultJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public void setViolateExecutionOnNonTightHtml(boolean shouldReportViolation) {
        super.setViolateExecutionOnNonTightHtml(shouldReportViolation);
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        boolean containsJavadocTag;
        DetailAST parentAst = MissingDeprecatedCheck.getParent(this.getBlockCommentAst());
        boolean containsAnnotation = AnnotationUtil.containsAnnotation(parentAst, DEPRECATED) || AnnotationUtil.containsAnnotation(parentAst, FQ_DEPRECATED);
        if (containsAnnotation ^ (containsJavadocTag = this.containsDeprecatedTag(ast))) {
            this.log(parentAst.getLineNo(), MSG_KEY_ANNOTATION_MISSING_DEPRECATED, new Object[0]);
        }
    }

    private boolean containsDeprecatedTag(DetailNode javadoc) {
        boolean found = false;
        for (DetailNode child : javadoc.getChildren()) {
            if (child.getType() != 10071 || child.getChildren()[0].getType() != 8) continue;
            if (found) {
                this.log(child.getLineNumber(), MSG_KEY_JAVADOC_DUPLICATE_TAG, JavadocTagInfo.DEPRECATED.getText());
            }
            found = true;
        }
        return found;
    }

    private static DetailAST getParent(DetailAST commentBlock) {
        DetailAST result = commentBlock.getParent();
        if (TokenUtil.isRootNode(result)) {
            result = commentBlock.getNextSibling();
        }
        while (true) {
            int type;
            if (TYPES_HASH_SET.get(type = result.getType())) {
                result = result.getParent();
                continue;
            }
            if (type != 144) break;
            result = result.getNextSibling();
        }
        return result;
    }
}

