/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@StatelessCheck
public class JavadocBlockTagLocationCheck
extends AbstractJavadocCheck {
    public static final String MSG_BLOCK_TAG_LOCATION = "javadoc.blockTagLocation";
    private static final Pattern JAVADOC_BLOCK_TAG_PATTERN = Pattern.compile("\\s@(\\w+)");
    private static final String[] DEFAULT_TAGS = new String[]{"author", "deprecated", "exception", "hidden", "param", "provides", "return", "see", "serial", "serialData", "serialField", "since", "throws", "uses", "version"};
    private Set<String> tags;

    public JavadocBlockTagLocationCheck() {
        this.setTags(DEFAULT_TAGS);
    }

    public final void setTags(String ... values) {
        this.tags = Arrays.stream(values).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return new int[]{10074};
    }

    @Override
    public int[] getAcceptableJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return this.getRequiredJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (!JavadocBlockTagLocationCheck.isCommentOrInlineTag(ast.getParent())) {
            Matcher tagMatcher = JAVADOC_BLOCK_TAG_PATTERN.matcher(ast.getText());
            while (tagMatcher.find()) {
                String tagName = tagMatcher.group(1);
                if (!this.tags.contains(tagName)) continue;
                this.log(ast.getLineNumber(), MSG_BLOCK_TAG_LOCATION, tagName);
            }
        }
    }

    private static boolean isCommentOrInlineTag(DetailNode node) {
        return node.getType() == 10072 || node.getType() == 10073;
    }
}

