/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavadocMetadataScraperUtil {
    private static final Pattern TOKEN_TEXT_PATTERN = Pattern.compile("([A-Z_]{2,})+");

    private JavadocMetadataScraperUtil() {
    }

    public static String constructSubTreeText(DetailNode node, int childLeftLimit, int childRightLimit) {
        DetailNode detailNode = node;
        ArrayDeque<DetailNode> stack = new ArrayDeque<DetailNode>();
        stack.addFirst(detailNode);
        HashSet<DetailNode> visited = new HashSet<DetailNode>();
        StringBuilder result = new StringBuilder(1024);
        while (!stack.isEmpty()) {
            detailNode = (DetailNode)stack.removeFirst();
            if (visited.add(detailNode) && JavadocMetadataScraperUtil.isContentToWrite(detailNode)) {
                String childText = detailNode.getText();
                if (detailNode.getParent().getType() == 10072) {
                    childText = JavadocMetadataScraperUtil.adjustCodeInlineTagChildToHtml(detailNode);
                }
                result.insert(0, childText);
            }
            for (DetailNode child : detailNode.getChildren()) {
                if (child.getParent().equals(node) && (child.getIndex() < childLeftLimit || child.getIndex() > childRightLimit) || visited.contains(child)) continue;
                stack.addFirst(child);
            }
        }
        return result.toString().trim();
    }

    private static boolean isContentToWrite(DetailNode detailNode) {
        return detailNode.getType() != 1 && (detailNode.getType() == 10074 || !TOKEN_TEXT_PATTERN.matcher(detailNode.getText()).matches());
    }

    public static String adjustCodeInlineTagChildToHtml(DetailNode codeChild) {
        return switch (codeChild.getType()) {
            case 20 -> "</code>";
            case 4 -> "";
            case 45 -> codeChild.getText().replace("@", "") + ">";
            case 19 -> "<";
            default -> codeChild.getText();
        };
    }

    private static Optional<DetailNode> getFirstChildOfType(DetailNode node, int tokenType, int offset) {
        return Arrays.stream(node.getChildren()).filter(child -> child.getIndex() >= offset && child.getType() == tokenType).findFirst();
    }

    public static boolean isChildNodeTextMatches(DetailNode ast, Pattern pattern) {
        return JavadocMetadataScraperUtil.getFirstChildOfType(ast, 10074, 0).map(DetailNode::getText).map(pattern::matcher).map(Matcher::matches).orElse(Boolean.FALSE);
    }
}

