/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.BitSet;

@StatelessCheck
public class FinalParametersCheck
extends AbstractCheck {
    public static final String MSG_KEY = "final.parameter";
    private final BitSet primitiveDataTypes = TokenUtil.asBitSet(51, 53, 54, 56, 55, 57, 50, 52);
    private boolean ignorePrimitiveTypes;
    private boolean ignoreUnnamedParameters = true;

    public void setIgnorePrimitiveTypes(boolean ignorePrimitiveTypes) {
        this.ignorePrimitiveTypes = ignorePrimitiveTypes;
    }

    public void setIgnoreUnnamedParameters(boolean ignoreUnnamedParameters) {
        this.ignoreUnnamedParameters = ignoreUnnamedParameters;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 96, 156, 198};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 96) {
            this.visitCatch(ast);
        } else if (ast.getType() == 156) {
            this.visitForEachClause(ast);
        } else if (ast.getType() == 198) {
            this.visitPatternVariableDef(ast);
        } else {
            this.visitMethod(ast);
        }
    }

    private void visitPatternVariableDef(DetailAST patternVariableDef) {
        this.checkParam(patternVariableDef);
    }

    private void visitMethod(DetailAST method) {
        if (method.findFirstToken(7) != null) {
            DetailAST parameters = method.findFirstToken(20);
            TokenUtil.forEachChild(parameters, 21, this::checkParam);
        }
    }

    private void visitCatch(DetailAST catchClause) {
        this.checkParam(catchClause.findFirstToken(21));
    }

    private void visitForEachClause(DetailAST forEachClause) {
        DetailAST variableDef = forEachClause.findFirstToken(10);
        if (variableDef != null) {
            this.checkParam(variableDef);
        }
    }

    private void checkParam(DetailAST param) {
        if (!(param.findFirstToken(5).findFirstToken(39) != null || this.isIgnoredPrimitiveParam(param) || this.isIgnoredUnnamedParam(param) || CheckUtil.isReceiverParameter(param))) {
            DetailAST paramName = param.findFirstToken(58);
            DetailAST firstNode = CheckUtil.getFirstNode(param);
            this.log(firstNode, MSG_KEY, paramName.getText());
        }
    }

    private boolean isIgnoredPrimitiveParam(DetailAST paramDef) {
        boolean result = false;
        if (this.ignorePrimitiveTypes) {
            DetailAST type = paramDef.findFirstToken(13);
            DetailAST parameterType = type.getFirstChild();
            DetailAST arrayDeclarator = type.findFirstToken(17);
            if (arrayDeclarator == null && this.primitiveDataTypes.get(parameterType.getType())) {
                result = true;
            }
        }
        return result;
    }

    private boolean isIgnoredUnnamedParam(DetailAST paramDef) {
        DetailAST paramName = paramDef.findFirstToken(58);
        return this.ignoreUnnamedParameters && paramName != null && "_".equals(paramName.getText());
    }
}

