/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.checks.header.AbstractHeaderCheck;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.io.File;
import java.util.BitSet;

@StatelessCheck
public class HeaderCheck
extends AbstractHeaderCheck {
    public static final String MSG_MISSING = "header.missing";
    public static final String MSG_MISMATCH = "header.mismatch";
    private BitSet ignoreLines = new BitSet();

    private boolean isIgnoreLine(int lineNo) {
        return this.ignoreLines.get(lineNo);
    }

    private boolean isMatch(int lineNumber, String line) {
        return this.isIgnoreLine(lineNumber + 1) || this.getHeaderLines().get(lineNumber).equals(line);
    }

    public void setIgnoreLines(int ... lines) {
        this.ignoreLines = TokenUtil.asBitSet(lines);
    }

    @Override
    protected void processFiltered(File file, FileText fileText) {
        if (this.getHeaderLines().size() > fileText.size()) {
            this.log(1, MSG_MISSING, new Object[0]);
        } else {
            for (int i = 0; i < this.getHeaderLines().size(); ++i) {
                if (this.isMatch(i, fileText.get(i))) continue;
                this.log(i + 1, MSG_MISMATCH, this.getHeaderLines().get(i));
                break;
            }
        }
    }

    @Override
    protected void postProcessHeaderLines() {
    }
}

