/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.GlobalStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

@GlobalStatefulCheck
public class JavadocPackageCheck
extends AbstractFileSetCheck {
    public static final String MSG_LEGACY_PACKAGE_HTML = "javadoc.legacyPackageHtml";
    public static final String MSG_PACKAGE_INFO = "javadoc.packageInfo";
    private final Set<File> directoriesChecked = new HashSet<File>();
    private boolean allowLegacy;

    public JavadocPackageCheck() {
        this.setFileExtensions("java");
    }

    @Override
    public final void setFileExtensions(String ... extensions) {
        super.setFileExtensions(extensions);
    }

    @Override
    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        boolean isDirChecked;
        File dir;
        try {
            dir = file.getCanonicalFile().getParentFile();
        }
        catch (IOException exc) {
            throw new CheckstyleException("Exception while getting canonical path to file " + file.getPath(), exc);
        }
        boolean bl = isDirChecked = !this.directoriesChecked.add(dir);
        if (!isDirChecked) {
            Path packageInfo = Path.of(dir.getPath(), "package-info.java");
            Path packageHtml = Path.of(dir.getPath(), "package.html");
            if (Files.exists(packageInfo, new LinkOption[0])) {
                if (Files.exists(packageHtml, new LinkOption[0])) {
                    this.log(1, MSG_LEGACY_PACKAGE_HTML, new Object[0]);
                }
            } else if (!this.allowLegacy || !Files.exists(packageHtml, new LinkOption[0])) {
                this.log(1, MSG_PACKAGE_INFO, new Object[0]);
            }
        }
    }

    public void setAllowLegacy(boolean allowLegacy) {
        this.allowLegacy = allowLegacy;
    }
}

