/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Numbers;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class Linter {
    private static final Class<?> CLASS = Linter.class;
    private static final Set<String> KNOWN_FORMATS = Set.of("date-time", "date", "time", "duration", "full-date", "full-time", "email", "idn-email", "hostname", "idn-hostname", "ipv4", "ipv6", "uri", "uri-reference", "iri", "iri-reference", "uuid", "uri-template", "json-pointer", "relative-json-pointer", "regex");
    private static final Set<String> KNOWN_KEYWORDS = Set.of("$anchor", "$comment", "$defs", "$id", "$recursiveAnchor", "$recursiveRef", "$ref", "$schema", "$vocabulary", "additionalItems", "additionalProperties", "allOf", "anyOf", "const", "contains", "contentEncoding", "contentMediaType", "contentSchema", "default", "definitions", "dependencies", "dependentRequired", "dependentSchemas", "deprecated", "description", "enum", "examples", "exclusiveMinimum", "exclusiveMaximum", "format", "if", "then", "else", "items", "maxContains", "maximum", "maxItems", "maxLength", "maxProperties", "minContains", "minimum", "minItems", "minLength", "minProperties", "multipleOf", "not", "oneOf", "pattern", "patternProperties", "properties", "propertyNames", "readOnly", "required", "title", "type", "unevaluatedItems", "unevaluatedProperties", "uniqueItems", "writeOnly");
    private static final List<Consumer<Context>> STRING_RULES = List.of(context -> {
        if (context.is("format") && !KNOWN_FORMATS.contains(context.string())) {
            context.addIssue("unknown format: \"" + Strings.jsonString(context.string()) + "\"");
        }
    }, context -> {
        if (context.is("$id")) {
            try {
                URI id = URI.parse(context.string());
                if (!id.normalize().equals(id)) {
                    context.addIssue("unnormalized ID: \"" + Strings.jsonString(context.string()) + "\"");
                }
                if (context.spec().compareTo(Specification.DRAFT_2019_09) >= 0 && id.rawFragment() != null && id.rawFragment().isEmpty()) {
                    context.addIssue("empty fragment: \"" + Strings.jsonString(context.string()) + "\"");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }, context -> {
        if (context.is("$ref") && context.string().startsWith("#")) {
            JsonElement o = context.schema();
            JSONPath path = JSONPath.fromJSONPointer(context.string().substring(1));
            if (!path.isAbsolute()) {
                context.addIssue("bad JSON Pointer: \"" + context.string() + "\"");
            } else {
                for (String part : path) {
                    if (!o.isJsonObject() || !o.getAsJsonObject().has(part)) {
                        context.addIssue("reference not found: \"" + Strings.jsonString(context.string()) + "\"");
                        break;
                    }
                    o = o.getAsJsonObject().get(part);
                }
            }
        }
    });
    private static final List<Consumer<Context>> ARRAY_RULES = List.of(context -> {
        if (context.is("items") && context.array().size() <= 0) {
            context.addIssue("empty items array");
        }
    });
    private static final List<Consumer<Context>> PROPERTIES_RULES = List.of(context -> context.object().keySet().forEach(name -> {
        if (name.startsWith("$")) {
            context.addIssue("property name starts with '$': \"" + Strings.jsonString(name) + "\"");
        }
    }));
    private static final List<Consumer<Context>> OBJECT_RULES = List.of(context -> {
        if (context.object().has("$schema") && context.parent() != null && !context.object().has("$id")) {
            context.addIssue("\"$schema\" in subschema without sibling \"$id\"");
        }
    }, context -> {
        JsonElement items;
        if (context.object().has("additionalItems") && ((items = context.object().get("items")) == null || !items.isJsonArray())) {
            context.addIssue("\"additionalItems\" without array-form \"items\"");
        }
    }, context -> {
        context.addIssue(Linter.compareExclusiveMinMax(context.object(), "exclusiveMinimum", "exclusiveMaximum"));
        context.addIssue(Linter.compareMinMax(context.object(), "minimum", "maximum"));
        context.addIssue(Linter.compareMinMax(context.object(), "minItems", "maxItems"));
        context.addIssue(Linter.compareMinMax(context.object(), "minLength", "maxLength"));
        context.addIssue(Linter.compareMinMax(context.object(), "minProperties", "maxProperties"));
    }, context -> {
        context.addIssue(Linter.checkType(context.object(), "additionalItems", List.of("array")));
        context.addIssue(Linter.checkType(context.object(), "additionalProperties", List.of("object")));
        context.addIssue(Linter.checkType(context.object(), "contains", List.of("array")));
        context.addIssue(Linter.checkType(context.object(), "exclusiveMaximum", List.of("number", "integer")));
        context.addIssue(Linter.checkType(context.object(), "exclusiveMinimum", List.of("number", "integer")));
        context.addIssue(Linter.checkType(context.object(), "format", List.of("string")));
        context.addIssue(Linter.checkType(context.object(), "items", List.of("array")));
        context.addIssue(Linter.checkType(context.object(), "maximum", List.of("number", "integer")));
        context.addIssue(Linter.checkType(context.object(), "maxItems", List.of("array")));
        context.addIssue(Linter.checkType(context.object(), "maxLength", List.of("string")));
        context.addIssue(Linter.checkType(context.object(), "maxProperties", List.of("object")));
        context.addIssue(Linter.checkType(context.object(), "minimum", List.of("number", "integer")));
        context.addIssue(Linter.checkType(context.object(), "minItems", List.of("array")));
        context.addIssue(Linter.checkType(context.object(), "minLength", List.of("string")));
        context.addIssue(Linter.checkType(context.object(), "minProperties", List.of("object")));
        context.addIssue(Linter.checkType(context.object(), "multipleOf", List.of("number", "integer")));
        context.addIssue(Linter.checkType(context.object(), "pattern", List.of("string")));
        context.addIssue(Linter.checkType(context.object(), "patternProperties", List.of("object")));
        context.addIssue(Linter.checkType(context.object(), "properties", List.of("object")));
        context.addIssue(Linter.checkType(context.object(), "propertyNames", List.of("object")));
        context.addIssue(Linter.checkType(context.object(), "required", List.of("object")));
        context.addIssue(Linter.checkType(context.object(), "uniqueItems", List.of("array")));
    }, context -> {
        if (context.spec() != null) {
            if (context.spec().compareTo(Specification.DRAFT_2019_09) >= 0) {
                context.object().keySet().forEach(name -> {
                    if (Validator.OLD_KEYWORDS_DRAFT_2019_09.contains(name)) {
                        context.addIssue("\"" + name + "\" was removed in Draft 2019-09");
                    }
                });
            } else {
                context.object().keySet().forEach(name -> {
                    if (Validator.NEW_KEYWORDS_DRAFT_2019_09.contains(name)) {
                        context.addIssue("\"" + name + "\" was added in Draft 2019-09");
                    }
                });
            }
            if (context.spec().compareTo(Specification.DRAFT_07) < 0) {
                context.object().keySet().forEach(name -> {
                    if (Validator.NEW_KEYWORDS_DRAFT_07.contains(name)) {
                        context.addIssue("\"" + name + "\" was added in Draft-07");
                    }
                });
            }
        }
    }, context -> {
        if (context.spec() == null || context.spec().compareTo(Specification.DRAFT_2019_09) >= 0) {
            JsonElement items;
            if (context.object().has("minContains") && !context.object().has("contains")) {
                context.addIssue("\"minContains\" without \"contains\"");
            }
            if (context.object().has("maxContains") && !context.object().has("contains")) {
                context.addIssue("\"maxContains\" without \"contains\"");
            }
            if (context.object().has("unevaluatedItems") && (items = context.object().get("items")) != null && !items.isJsonArray()) {
                context.addIssue("\"unevaluatedItems\" without array-form \"items\"");
            }
            context.addIssue(Linter.compareMinMax(context.object(), "minContains", "maxContains"));
            context.addIssue(Linter.checkType(context.object(), "contentSchema", List.of("string")));
            context.addIssue(Linter.checkType(context.object(), "dependentRequired", List.of("object")));
            context.addIssue(Linter.checkType(context.object(), "dependentSchemas", List.of("object")));
            context.addIssue(Linter.checkType(context.object(), "maxContains", List.of("array")));
            context.addIssue(Linter.checkType(context.object(), "minContains", List.of("array")));
            context.addIssue(Linter.checkType(context.object(), "unevaluatedItems", List.of("array")));
            context.addIssue(Linter.checkType(context.object(), "unevaluatedProperties", List.of("object")));
        }
        if (context.spec() == null || context.spec().compareTo(Specification.DRAFT_2019_09) < 0) {
            context.addIssue(Linter.checkType(context.object(), "dependencies", List.of("object")));
        }
        if (context.spec() == null || context.spec().compareTo(Specification.DRAFT_07) >= 0) {
            if (context.object().has("then") && !context.object().has("if")) {
                context.addIssue("\"then\" without \"if\"");
            }
            if (context.object().has("else") && !context.object().has("if")) {
                context.addIssue("\"else\" without \"if\"");
            }
            context.addIssue(Linter.checkType(context.object(), "contentEncoding", List.of("string")));
            context.addIssue(Linter.checkType(context.object(), "contentMediaType", List.of("string")));
        }
    }, context -> {
        if (!context.is("$vocabulary")) {
            context.object().keySet().forEach(name -> {
                if (!KNOWN_KEYWORDS.contains(name)) {
                    Set similars = KNOWN_KEYWORDS.stream().filter(name::equalsIgnoreCase).map(Strings::jsonString).collect(Collectors.toSet());
                    if (!similars.isEmpty()) {
                        context.addIssue("unknown but similar: " + similars + ": \"" + Strings.jsonString(name) + "\"");
                    } else {
                        context.addIssue("unknown keyword: \"" + Strings.jsonString(name) + "\"");
                    }
                }
            });
        }
    }, context -> {
        if (context.spec() != null && context.spec().compareTo(Specification.DRAFT_2019_09) < 0 && context.object().has("$ref") && context.object().size() > 1) {
            context.addIssue("\"$ref\" with siblings");
        }
    }, context -> {
        context.addIssue(Linter.checkImpliedType(context.object(), "default"));
        context.addIssue(Linter.checkImpliedType(context.object(), "const"));
    }, context -> {
        JsonElement elem = context.object().get("enum");
        if (elem != null && elem.isJsonArray()) {
            HashSet set = new HashSet();
            if (!StreamSupport.stream(elem.getAsJsonArray().spliterator(), false).allMatch(set::add)) {
                context.addIssue("Non-unique \"enum\"");
            }
        }
    }, context -> {
        context.addIssue(Linter.checkNotEmpty(context.object(), "enum"));
        context.addIssue(Linter.checkNotEmpty(context.object(), "allOf"));
        context.addIssue(Linter.checkNotEmpty(context.object(), "anyOf"));
        context.addIssue(Linter.checkNotEmpty(context.object(), "oneOf"));
    });
    private final List<Consumer<Context>> nullRules = new ArrayList<Consumer<Context>>();
    private final List<Consumer<Context>> primitiveRules = new ArrayList<Consumer<Context>>();
    private final List<Consumer<Context>> stringRules = new ArrayList<Consumer<Context>>();
    private final List<Consumer<Context>> objectRules = new ArrayList<Consumer<Context>>();
    private final List<Consumer<Context>> arrayRules = new ArrayList<Consumer<Context>>();
    private final List<Consumer<Context>> otherRules = new ArrayList<Consumer<Context>>();

    public static void main(String[] args) throws IOException {
        JsonElement schema;
        if (args.length != 1) {
            System.out.println("Usage: " + CLASS.getName() + " <schema>");
            System.exit(1);
            return;
        }
        try {
            URL url = new URL(args[0]);
            URLConnection conn = url.openConnection();
            System.out.println(Optional.ofNullable(conn.getContentType()).map(s -> "Schema URL: Content-Type=" + s).orElse("Schema URL: has no Content-Type"));
            schema = JSON.parse(conn.getInputStream());
        }
        catch (MalformedURLException ex) {
            schema = JSON.parse(new File(args[0]));
        }
        Linter linter = new Linter();
        Map<JSONPath, List<String>> issues = linter.check(schema);
        JsonArray outputArr = new JsonArray();
        issues.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            JsonObject instanceObj = new JsonObject();
            outputArr.add((JsonElement)instanceObj);
            instanceObj.addProperty("instanceLocation", ((JSONPath)e.getKey()).toString());
            JsonArray issueArr = new JsonArray();
            instanceObj.add("issues", (JsonElement)issueArr);
            ((List)e.getValue()).forEach(arg_0 -> ((JsonArray)issueArr).add(arg_0));
        });
        JSON.print(System.out, (JsonElement)outputArr, "    ");
        System.out.println();
    }

    public Map<JSONPath, List<String>> check(JsonElement schema) {
        HashMap<JSONPath, List<String>> issues = new HashMap<JSONPath, List<String>>();
        Context context = new Context(issues);
        context.schema = schema;
        Consumer<List> processRules = list -> list.forEach(f -> f.accept(context));
        try {
            JSON.traverseSchema(URI.parseUnchecked(""), null, schema, (e, parent, path, state) -> {
                context.element = e;
                context.parent = parent;
                context.path = path;
                context.spec = state.spec();
                context.isKeyword = !state.isNotKeyword();
                boolean bl = context.isSchema = !state.isNotSchema();
                if (e.isJsonNull()) {
                    processRules.accept(this.nullRules);
                } else if (e.isJsonPrimitive()) {
                    processRules.accept(this.primitiveRules);
                    if (e.getAsJsonPrimitive().isString()) {
                        if (context.isKeyword()) {
                            processRules.accept(STRING_RULES);
                        }
                        processRules.accept(this.stringRules);
                    }
                } else if (e.isJsonArray()) {
                    processRules.accept(ARRAY_RULES);
                    processRules.accept(this.arrayRules);
                } else if (e.isJsonObject()) {
                    if (state.isProperties()) {
                        processRules.accept(PROPERTIES_RULES);
                    } else if (context.isSchema() && (!context.isUnknown() || context.path().size() > 1)) {
                        processRules.accept(OBJECT_RULES);
                    }
                    processRules.accept(this.objectRules);
                }
                processRules.accept(this.otherRules);
            });
        }
        catch (MalformedSchemaException ex) {
            throw new RuntimeException(ex);
        }
        return issues;
    }

    public void addPrimitiveRule(Consumer<Context> rule) {
        Objects.requireNonNull(rule, "rule");
        this.primitiveRules.add(rule);
    }

    public void addNullRule(Consumer<Context> rule) {
        Objects.requireNonNull(rule, "rule");
        this.nullRules.add(rule);
    }

    public void addStringRule(Consumer<Context> rule) {
        Objects.requireNonNull(rule, "rule");
        this.stringRules.add(rule);
    }

    public void addObjectRule(Consumer<Context> rule) {
        Objects.requireNonNull(rule, "rule");
        this.objectRules.add(rule);
    }

    public void addArrayRule(Consumer<Context> rule) {
        Objects.requireNonNull(rule, "rule");
        this.arrayRules.add(rule);
    }

    public void addRule(Consumer<Context> rule) {
        Objects.requireNonNull(rule, "rule");
        this.otherRules.add(rule);
    }

    private static String compareMinMax(JsonObject o, String minName, String maxName) {
        BigDecimal max;
        BigDecimal min;
        if (!o.has(minName) || !o.has(maxName)) {
            return null;
        }
        JsonElement minE = o.get(minName);
        JsonElement maxE = o.get(maxName);
        if (JSON.isNumber(minE) && JSON.isNumber(maxE) && (min = Numbers.valueOf(minE.getAsString())).compareTo(max = Numbers.valueOf(maxE.getAsString())) > 0) {
            return "\"" + minName + "\" > \"" + maxName + "\"";
        }
        return null;
    }

    private static String compareExclusiveMinMax(JsonObject o, String minName, String maxName) {
        BigDecimal max;
        BigDecimal min;
        if (!o.has(minName) || !o.has(maxName)) {
            return null;
        }
        JsonElement minE = o.get(minName);
        JsonElement maxE = o.get(maxName);
        if (JSON.isNumber(minE) && JSON.isNumber(maxE) && (min = Numbers.valueOf(minE.getAsString())).compareTo(max = Numbers.valueOf(maxE.getAsString())) >= 0) {
            return "\"" + minName + "\" >= \"" + maxName + "\"";
        }
        return null;
    }

    private static String checkImpliedType(JsonObject o, String name) {
        List<String> types;
        JsonElement e = o.get(name);
        if (e == null) {
            return null;
        }
        if (JSON.isString(e)) {
            types = List.of("string");
        } else if (JSON.isBoolean(e)) {
            types = List.of("boolean");
        } else if (JSON.isNumber(e)) {
            BigDecimal n = Numbers.valueOf(e.getAsString());
            types = Numbers.isInteger(n) ? List.of("number", "integer") : List.of("number");
        } else if (e.isJsonArray()) {
            types = List.of("array");
        } else if (e.isJsonObject()) {
            types = List.of("object");
        } else if (e.isJsonNull()) {
            types = List.of("null");
        } else {
            return null;
        }
        return Linter.checkType(o, name, types);
    }

    private static String checkType(JsonObject o, String name, List<String> expected) {
        Object got;
        if (!o.has(name)) {
            return null;
        }
        JsonElement type = o.get("type");
        if (type == null) {
            return "\"" + name + "\" with no \"type\"";
        }
        if (JSON.isString(type)) {
            if (expected.contains(type.getAsString())) {
                return null;
            }
            got = "\"" + type.getAsString() + "\"";
        } else if (type.isJsonArray()) {
            boolean allStrings = true;
            for (JsonElement e2 : type.getAsJsonArray()) {
                if (!JSON.isString(e2)) {
                    allStrings = false;
                    continue;
                }
                if (!expected.contains(e2.getAsString())) continue;
                return null;
            }
            got = allStrings ? StreamSupport.stream(type.getAsJsonArray().spliterator(), false).map(e -> "\"" + e.getAsString() + "\"").collect(Collectors.toList()).toString() : "mixed types";
        } else {
            return "\"" + name + "\" with no valid \"type\"";
        }
        String want = expected.size() == 1 ? "\"" + expected.get(0) + "\"" : "one of " + expected.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList());
        return "\"" + name + "\" type: want " + want + ", got " + (String)got;
    }

    private static String checkNotEmpty(JsonObject o, String name) {
        JsonElement e = o.get(name);
        if (e != null && e.isJsonArray() && e.getAsJsonArray().size() == 0) {
            return "empty \"" + name + "\"";
        }
        return null;
    }

    public static final class Context {
        private final Map<JSONPath, List<String>> issues;
        JsonElement schema;
        JsonElement element;
        JsonElement parent;
        JSONPath path;
        Specification spec;
        boolean isKeyword;
        boolean isSchema;

        Context(Map<JSONPath, List<String>> issues) {
            this.issues = issues;
        }

        public boolean isKeyword() {
            return this.isKeyword;
        }

        public boolean isSchema() {
            return this.isSchema;
        }

        public JsonElement schema() {
            return this.schema;
        }

        public JsonElement element() {
            return this.element;
        }

        public String string() {
            return this.element.getAsString();
        }

        public JsonObject object() {
            return this.element.getAsJsonObject();
        }

        public JsonArray array() {
            return this.element.getAsJsonArray();
        }

        public JsonElement parent() {
            return this.parent;
        }

        public JSONPath path() {
            return this.path;
        }

        public Specification spec() {
            return this.spec;
        }

        public boolean is(String name) {
            return this.path.endsWith(name);
        }

        private boolean isUnknown() {
            if (this.path.isEmpty()) {
                return false;
            }
            if (this.parent != null && this.parent.isJsonArray()) {
                return false;
            }
            return !KNOWN_KEYWORDS.contains(this.path.get(this.path.size() - 1));
        }

        public void addIssue(String issue) {
            if (issue != null) {
                this.issues.computeIfAbsent(this.path, k -> new ArrayList()).add(issue);
            }
        }
    }
}

