/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.qindesign.json.schema.Annotation;
import com.qindesign.json.schema.Error;
import com.qindesign.json.schema.JSONPath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class Results {
    private Results() {
    }

    public static List<Error<?>> processErrors(Map<JSONPath, Map<JSONPath, Error<?>>> errors) {
        ArrayList list = new ArrayList();
        errors.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> ((Map)e.getValue()).values().stream().filter(err -> !err.isPruned() && !err.result).sorted(Comparator.comparing(err -> err.loc.keyword)).forEach(list::add));
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            int i = iter.nextIndex();
            Error err = (Error)iter.next();
            if (!list.subList(i + 1, list.size()).stream().anyMatch(err2 -> err2.loc.instance.startsWith(err.loc.instance) && err2.loc.keyword.startsWith(err.loc.keyword))) continue;
            iter.remove();
        }
        return list;
    }

    public static List<Annotation<?>> processAnnotations(Map<JSONPath, Map<String, Map<JSONPath, Annotation<?>>>> annotations) {
        ArrayList list = new ArrayList();
        annotations.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(byInstanceLoc -> ((Map)byInstanceLoc.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(bySchemaLoc -> ((Map)bySchemaLoc.getValue()).values().stream().filter(Annotation::isValid).sorted(Comparator.comparing(a -> a.loc.keyword)).forEach(list::add)));
        return list;
    }
}

