/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.qindesign.json.schema.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Specification {
    DRAFT_06("http://json-schema.org/draft-06/schema"),
    DRAFT_07("http://json-schema.org/draft-07/schema"),
    DRAFT_2019_09("https://json-schema.org/draft/2019-09/schema");

    private static final Map<URI, Specification> SPECS;
    private final URI id;

    public static Specification of(URI id) {
        return SPECS.get(id);
    }

    private Specification(String uri) {
        Objects.requireNonNull(uri, "uri");
        this.id = URI.parseUnchecked(uri);
    }

    public URI id() {
        return this.id;
    }

    static {
        SPECS = Stream.of(Specification.values()).collect(Collectors.toUnmodifiableMap(Specification::id, Function.identity()));
    }
}

