/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import java.util.Arrays;
import java.util.BitSet;

public final class Strings {
    private static final String VALID_FRAGMENT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~!$&'()*+,;=:@/?";
    private static final String HEX_CHARS = "01234567890ABCDEFabcdef";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final BitSet validHex = Strings.toASCIIBitSet("01234567890ABCDEFabcdef");
    private static final BitSet validFragment = Strings.toASCIIBitSet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~!$&'()*+,;=:@/?");
    private static final char[] BASE64_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public static final int[] BASE64_BITS = new int[256];

    private Strings() {
    }

    public static String jsonString(String s) {
        StringBuilder sb = new StringBuilder();
        s.chars().forEach(c -> {
            switch (c) {
                case 34: {
                    sb.append("\\\"");
                    break;
                }
                case 92: {
                    sb.append("\\\\");
                    break;
                }
                case 8: {
                    sb.append("\\b");
                    break;
                }
                case 12: {
                    sb.append("\\f");
                    break;
                }
                case 10: {
                    sb.append("\\n");
                    break;
                }
                case 13: {
                    sb.append("\\r");
                    break;
                }
                case 9: {
                    sb.append("\\t");
                    break;
                }
                default: {
                    if (c < 32) {
                        sb.append(String.format("\\u%04x", c));
                        break;
                    }
                    sb.append((char)c);
                }
            }
        });
        return sb.toString();
    }

    private static BitSet toASCIIBitSet(String s) {
        BitSet bs = new BitSet(128);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Character not ASCII[" + i + "]: 0x" + String.format("%04x", c));
            }
            bs.set(c);
        }
        return bs;
    }

    public static URI jsonPointerToURI(String ptr) {
        try {
            return new URI(null, null, null, null, ptr);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Unexpected bad URI", ex);
        }
    }

    public static String jsonPointerToken(String s) {
        return s.replace("~", "~0").replace("/", "~1");
    }

    public static String fromJSONPointerToken(String s) {
        if (s.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Bad character ('/'): " + s);
        }
        if (s.indexOf(126) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int[] tildeState = new int[]{-1};
        s.codePoints().forEach(c -> {
            if (tildeState[0] == 126) {
                if (c == 48) {
                    sb.append('~');
                } else if (c == 49) {
                    sb.append('/');
                } else {
                    throw new IllegalArgumentException("Bad escape character (0x" + Integer.toHexString(c) + "): " + s);
                }
                tildeState[0] = -1;
                return;
            }
            if (c == 126) {
                tildeState[0] = 126;
                return;
            }
            sb.appendCodePoint(c);
        });
        if (tildeState[0] >= 0) {
            throw new IllegalArgumentException("Extra '~': " + s);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBase64(String s) {
        if ((s.length() & 3) != 0) {
            return false;
        }
        char[] buf = new char[4];
        boolean end = false;
        for (int i = 0; i < s.length(); i += 4) {
            if (end) {
                return false;
            }
            s.getChars(i, i + 4, buf, 0);
            if ((buf[0] | buf[1] | buf[2] | buf[3]) > 255) {
                return false;
            }
            int b0 = BASE64_BITS[buf[0]];
            int b1 = BASE64_BITS[buf[1]];
            int b2 = BASE64_BITS[buf[2]];
            int b3 = BASE64_BITS[buf[3]];
            if ((b0 | b1 | b2 | b3) >= 0) continue;
            if (b0 < 0 || b1 < 0) {
                if (b0 != -2 || b1 != -2 || b2 != -2 || b3 != -2) {
                    return false;
                }
            } else if (b2 < 0) {
                if (b2 != -2) return false;
                if (b3 != -2) {
                    return false;
                }
            } else if (b3 != -2) {
                return false;
            }
            end = true;
        }
        return true;
    }

    static {
        Arrays.fill(BASE64_BITS, -1);
        for (int i = 0; i < BASE64_ALPHABET.length; ++i) {
            Strings.BASE64_BITS[Strings.BASE64_ALPHABET[i]] = i;
        }
        Strings.BASE64_BITS[45] = 62;
        Strings.BASE64_BITS[95] = 63;
        Strings.BASE64_BITS[61] = -2;
    }
}

