/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;

public final class URIs {
    private URIs() {
    }

    public static boolean hasNonEmptyFragment(URI uri) {
        return uri.rawFragment() != null && !uri.rawFragment().isEmpty();
    }

    public static boolean isNotFragmentOnly(URI uri) {
        return uri.scheme() != null || uri.rawAuthority() != null || !uri.rawPath().isEmpty() || uri.rawQuery() != null;
    }

    public static URI stripFragment(URI uri) {
        if (uri.rawFragment() == null) {
            return uri;
        }
        try {
            return new URI(uri.scheme(), uri.authority(), uri.path(), uri.query(), null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Unexpected bad URI: " + uri, ex);
        }
    }
}

