/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.qindesign.json.schema.Annotation;
import com.qindesign.json.schema.Error;
import com.qindesign.json.schema.Id;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Options;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.URIs;
import com.qindesign.json.schema.ValidatorContext;
import com.qindesign.json.schema.keywords.CoreSchema;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Validator {
    private static final Class<?> CLASS = Validator.class;
    private static final Logger logger = Logger.getLogger(CLASS.getName());
    private static final Map<URI, URL> KNOWN_RESOURCES = Stream.of({"https://json-schema.org/draft/2019-09/schema", "/schemas/draft-2019-09/schema.json"}, {"https://json-schema.org/draft/2019-09/meta/core", "/schemas/draft-2019-09/meta/core.json"}, {"https://json-schema.org/draft/2019-09/meta/applicator", "/schemas/draft-2019-09/meta/applicator.json"}, {"https://json-schema.org/draft/2019-09/meta/validation", "/schemas/draft-2019-09/meta/validation.json"}, {"https://json-schema.org/draft/2019-09/meta/meta-data", "/schemas/draft-2019-09/meta/meta-data.json"}, {"https://json-schema.org/draft/2019-09/meta/format", "/schemas/draft-2019-09/meta/format.json"}, {"https://json-schema.org/draft/2019-09/meta/content", "/schemas/draft-2019-09/meta/content.json"}, {"http://json-schema.org/draft-07/schema", "/schemas/draft-07/schema.json"}, {"http://json-schema.org/draft-06/schema", "/schemas/draft-06/schema.json"}).collect(Collectors.toUnmodifiableMap(data -> URI.parseUnchecked((String)data[0]), data -> {
        URL url = CLASS.getResource((String)data[1]);
        if (url == null) {
            throw new MissingResourceException("Can't find resource \"" + data[1] + "\" in " + CLASS.getName(), CLASS.getName(), (String)data[1]);
        }
        return url;
    }));
    private static final Set<URI> KNOWN_SCHEMAS = Arrays.stream(Specification.values()).map(Specification::id).collect(Collectors.toUnmodifiableSet());
    public static final Set<String> NEW_KEYWORDS_DRAFT_2019_09 = Set.of("$anchor", "$defs", "$recursiveAnchor", "$recursiveRef", "$vocabulary", "dependentSchemas", "unevaluatedItems", "unevaluatedProperties", "dependentRequired", "maxContains", "minContains", "contentSchema", "deprecated");
    public static final Set<String> OLD_KEYWORDS_DRAFT_2019_09 = Set.of("definitions", "dependencies");
    private static final Set<String> NEW_FORMATS_DRAFT_2019_09 = Set.of("duration", "uuid");
    public static final Set<String> NEW_KEYWORDS_DRAFT_07 = Set.of("$comment", "if", "then", "else", "readOnly", "writeOnly", "contentMediaType", "contentEncoding");
    private static final Set<String> NEW_FORMATS_DRAFT_07 = Set.of("iri", "iri-reference", "idn-email", "idn-hostname", "relative-json-pointer", "regex", "date", "time");
    private final ValidatorContext context;

    public Validator(JsonElement schema, URI baseURI, Map<URI, JsonElement> knownIDs, Map<URI, URL> knownURLs, Options options) throws MalformedSchemaException {
        Objects.requireNonNull(schema, "schema");
        Objects.requireNonNull(baseURI, "baseURI");
        if (!baseURI.isAbsolute()) {
            throw new IllegalArgumentException("baseURI must be absolute");
        }
        if (URIs.hasNonEmptyFragment(baseURI)) {
            throw new IllegalArgumentException("baseURI has a non-empty fragment");
        }
        if (options == null) {
            options = new Options();
        }
        baseURI = baseURI.normalize();
        HashMap<URI, URL> autoResolved = null;
        if (options.is(Option.AUTO_RESOLVE)) {
            autoResolved = new HashMap<URI, URL>();
        }
        HashMap<URI, Boolean> vocabularies = new HashMap<URI, Boolean>();
        Map<URI, Id> ids = Validator.prepareSchema(baseURI, schema, options, autoResolved, vocabularies);
        if (knownIDs != null) {
            for (Map.Entry<URI, JsonElement> e : knownIDs.entrySet()) {
                URI uRI = e.getKey().normalize();
                Map<URI, Id> ids2 = Validator.prepareSchema(uRI, e.getValue(), options, autoResolved, null);
                ids2.forEach(ids::putIfAbsent);
            }
        }
        knownURLs = knownURLs == null ? new HashMap<URI, URL>() : new HashMap<URI, URL>(knownURLs);
        HashSet<URL> checkedURLs = new HashSet<URL>();
        if (autoResolved != null) {
            for (Map.Entry<Object, Object> entry : autoResolved.entrySet()) {
                if (knownURLs.putIfAbsent((URI)entry.getKey(), (URL)entry.getValue()) == null) continue;
                logger.warning("Duplicate URL: " + entry.getKey() + ": " + entry.getValue());
            }
            autoResolved.clear();
        }
        do {
            for (Map.Entry<Object, Object> entry : knownURLs.entrySet()) {
                InputStream urlIn;
                URL url;
                URI uri;
                block26: {
                    String path;
                    uri = ((URI)entry.getKey()).normalize();
                    url = (URL)entry.getValue();
                    if (!checkedURLs.add(url) || (path = url.getPath()).isEmpty() || path.endsWith("/")) continue;
                    urlIn = null;
                    try {
                        urlIn = url.openStream();
                        logger.info("Found resource: " + uri + ": " + url);
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "Error loading resource: " + uri + ": " + url, ex);
                        if (!options.is(Option.AUTO_RESOLVE)) break block26;
                        try {
                            url = uri.toURL();
                            urlIn = url.openStream();
                            entry.setValue(url);
                            logger.info("Found resource: " + uri + ": " + uri);
                        }
                        catch (IllegalArgumentException | MalformedURLException ex2) {
                            logger.log(Level.WARNING, "Not a valid resource: " + uri, ex2);
                        }
                        catch (IOException ex2) {
                            logger.log(Level.WARNING, "Error loading resource: " + uri + ": " + uri, ex2);
                        }
                    }
                }
                if (urlIn == null) continue;
                try {
                    InputStream in = urlIn;
                    try {
                        try {
                            Map<URI, Id> ids2 = Validator.prepareSchema(uri, JSON.parse(in), options, autoResolved, null);
                            ids2.forEach((uri1, id) -> {
                                if (ids.putIfAbsent((URI)uri1, (Id)id) != null) {
                                    logger.warning("Duplicate URI: " + uri1 + ": from " + id.rootURI);
                                }
                            });
                        }
                        catch (JsonParseException ex) {
                            logger.log(Level.SEVERE, "Error parsing resource: " + uri + ": " + url, ex);
                        }
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Error closing resource: " + url, ex);
                }
            }
            if (autoResolved == null) break;
            autoResolved.values().removeAll(checkedURLs);
            for (Map.Entry<Object, Object> entry : autoResolved.entrySet()) {
                if (knownURLs.putIfAbsent((URI)entry.getKey(), (URL)entry.getValue()) == null) continue;
                logger.warning("Duplicate URL: " + entry.getKey() + ": " + entry.getValue());
            }
        } while (!autoResolved.isEmpty());
        this.context = new ValidatorContext(baseURI, schema, false, ids, knownURLs, KNOWN_SCHEMAS, options);
        if (!vocabularies.isEmpty()) {
            vocabularies.forEach(this.context::setVocabulary);
        }
    }

    public static boolean isSchema(JsonElement e) {
        return e.isJsonObject() || JSON.isBoolean(e);
    }

    private static Map<URI, Id> prepareSchema(URI baseURI, JsonElement schema, Options options, Map<URI, URL> knownURLs, Map<URI, Boolean> vocabularies) throws MalformedSchemaException {
        boolean isDefaultSpec;
        Objects.requireNonNull(baseURI, "baseURI");
        Objects.requireNonNull(schema, "schema");
        Objects.requireNonNull(options, "options");
        if (!Validator.isSchema(schema)) {
            throw new MalformedSchemaException("not a schema", baseURI);
        }
        Specification spec = Validator.specificationFromSchema(schema);
        boolean bl = isDefaultSpec = spec == null;
        if (isDefaultSpec && (spec = (Specification)((Object)options.get(Option.SPECIFICATION))) == null && (spec = Validator.guessSpecification(schema)) == null) {
            spec = (Specification)((Object)options.get(Option.DEFAULT_SPECIFICATION));
        }
        Map<URI, Id> ids = Validator.scanIDs(baseURI, schema, spec);
        if (knownURLs != null) {
            URL url = null;
            try {
                url = baseURI.toURL();
            }
            catch (IllegalArgumentException | MalformedURLException ex) {
                logger.warning("AUTO_RESOLVE: not a valid base URL: " + baseURI);
            }
            URL baseURL = url;
            if (baseURL != null) {
                JSON.traverseSchema(baseURI, spec, schema, (e, parent, path, state) -> {
                    URI ref;
                    if (state.isNotKeyword() || !path.endsWith("$ref") && !path.endsWith("$recursiveRef")) {
                        return;
                    }
                    Supplier<URI> loc = () -> state.rootURI().resolve(Strings.jsonPointerToURI(path.toString()));
                    if (!JSON.isString(e)) {
                        throw new MalformedSchemaException("not a string", loc.get());
                    }
                    try {
                        ref = URI.parse(e.getAsString());
                    }
                    catch (URISyntaxException ex) {
                        throw new MalformedSchemaException("not a valid URI", loc.get());
                    }
                    if (!URIs.isNotFragmentOnly(ref)) {
                        return;
                    }
                    ref = URIs.stripFragment(ref).normalize();
                    URI uri = state.baseURI().resolve(ref);
                    if (!ids.containsKey(uri) && !KNOWN_RESOURCES.containsKey(uri)) {
                        try {
                            knownURLs.putIfAbsent(uri, uri.toURL());
                        }
                        catch (MalformedURLException ex) {
                            logger.warning("AUTO_RESOLVE: not a valid URL: " + ref);
                        }
                    }
                });
            }
        }
        if (isDefaultSpec && schema.isJsonObject()) {
            ValidatorContext context = new ValidatorContext(baseURI, schema, true, new HashMap<URI, Id>(), Collections.emptyMap(), KNOWN_SCHEMAS, new Options().set(Option.FORMAT, false));
            if (!new CoreSchema().apply((JsonElement)new JsonPrimitive(spec.id().toString()), null, schema.getAsJsonObject(), context)) {
                throw new MalformedSchemaException("schema does not validate against " + spec.id(), baseURI);
            }
            if (vocabularies != null) {
                vocabularies.putAll(context.vocabularies());
            }
        }
        return ids;
    }

    public boolean validate(JsonElement instance, Map<JSONPath, Map<String, Map<JSONPath, Annotation<?>>>> annotations, Map<JSONPath, Map<JSONPath, Error<?>>> errors) throws MalformedSchemaException {
        Objects.requireNonNull(instance, "instance");
        return this.context.apply(instance, annotations, errors);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement loadResource(URI uri) {
        URL url = KNOWN_RESOURCES.get(uri);
        if (url == null) {
            return null;
        }
        try (InputStream in = url.openStream();){
            if (in == null) {
                JsonElement jsonElement2 = null;
                return jsonElement2;
            }
            JsonElement jsonElement = JSON.parse(in);
            return jsonElement;
        }
        catch (IOException ex2) {
            logger.log(Level.SEVERE, "Error loading resource: " + uri, ex2);
        }
        return null;
    }

    public static Specification specificationFromSchema(JsonElement schema) {
        if (!schema.isJsonObject()) {
            return null;
        }
        JsonElement schemaVal = schema.getAsJsonObject().get("$schema");
        if (schemaVal != null && JSON.isString(schemaVal)) {
            try {
                URI uri = URI.parse(schemaVal.getAsString());
                if (uri.isAbsolute()) {
                    return Specification.of(URIs.stripFragment(uri.normalize()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Specification guessSpecification(JsonElement schema) {
        if (!schema.isJsonObject()) {
            return null;
        }
        JsonElement refVal = schema.getAsJsonObject().get("$ref");
        if (refVal != null && JSON.isString(refVal)) {
            try {
                URI uri = URI.parse(refVal.getAsString());
                if (uri.isAbsolute()) {
                    return Specification.of(URIs.stripFragment(uri.normalize()));
                }
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        HashSet couldBe = new HashSet();
        HashSet cantBe = new HashSet();
        try {
            JSON.traverseSchema(URI.parseUnchecked(""), null, schema, (e, parent, path, state) -> {
                if (!e.isJsonObject()) {
                    return;
                }
                e.getAsJsonObject().entrySet().forEach(entry -> {
                    switch ((String)entry.getKey()) {
                        case "$id": {
                            if (!JSON.isString((JsonElement)entry.getValue())) break;
                            try {
                                if (URIs.hasNonEmptyFragment(URI.parse(((JsonElement)entry.getValue()).getAsString()))) {
                                    cantBe.add(Specification.DRAFT_2019_09);
                                    couldBe.add(Specification.DRAFT_07);
                                    couldBe.add(Specification.DRAFT_06);
                                    break;
                                }
                                couldBe.add(Specification.DRAFT_2019_09);
                                couldBe.add(Specification.DRAFT_07);
                                couldBe.add(Specification.DRAFT_06);
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                            break;
                        }
                        case "format": {
                            if (!JSON.isString((JsonElement)entry.getValue())) break;
                            String format = ((JsonElement)entry.getValue()).getAsString();
                            if (NEW_FORMATS_DRAFT_2019_09.contains(format)) {
                                couldBe.add(Specification.DRAFT_2019_09);
                                cantBe.add(Specification.DRAFT_07);
                                cantBe.add(Specification.DRAFT_06);
                                break;
                            }
                            if (NEW_FORMATS_DRAFT_07.contains(format)) {
                                couldBe.add(Specification.DRAFT_2019_09);
                                couldBe.add(Specification.DRAFT_07);
                                cantBe.add(Specification.DRAFT_06);
                                break;
                            }
                            couldBe.add(Specification.DRAFT_2019_09);
                            couldBe.add(Specification.DRAFT_07);
                            couldBe.add(Specification.DRAFT_06);
                            break;
                        }
                        default: {
                            if (NEW_KEYWORDS_DRAFT_2019_09.contains(entry.getKey())) {
                                couldBe.add(Specification.DRAFT_2019_09);
                                cantBe.add(Specification.DRAFT_07);
                                cantBe.add(Specification.DRAFT_06);
                                break;
                            }
                            if (NEW_KEYWORDS_DRAFT_07.contains(entry.getKey())) {
                                couldBe.add(Specification.DRAFT_2019_09);
                                couldBe.add(Specification.DRAFT_07);
                                cantBe.add(Specification.DRAFT_06);
                                break;
                            }
                            if (OLD_KEYWORDS_DRAFT_2019_09.contains(entry.getKey())) {
                                cantBe.add(Specification.DRAFT_2019_09);
                                couldBe.add(Specification.DRAFT_07);
                                couldBe.add(Specification.DRAFT_06);
                                break;
                            }
                            couldBe.add(Specification.DRAFT_2019_09);
                            couldBe.add(Specification.DRAFT_07);
                            couldBe.add(Specification.DRAFT_06);
                        }
                    }
                });
            });
        }
        catch (MalformedSchemaException ex) {
            throw new RuntimeException(ex);
        }
        if (cantBe.size() >= Specification.values().length) {
            return null;
        }
        return couldBe.stream().filter(spec -> !cantBe.contains(spec)).max(Comparator.naturalOrder()).orElse(null);
    }

    public static Map<URI, Id> scanIDs(URI baseURI, JsonElement schema, Specification spec) throws MalformedSchemaException {
        if (URIs.hasNonEmptyFragment(baseURI)) {
            throw new IllegalArgumentException("Base URI has a non-empty fragment");
        }
        URI rootURI = URIs.stripFragment(baseURI).normalize();
        HashMap<URI, Id> ids = new HashMap<URI, Id>();
        JSON.traverseSchema(rootURI, spec, schema, (e, parent, path, state) -> {
            if (state.isNotSchema() || !e.isJsonObject()) {
                return;
            }
            Supplier<URI> loc = () -> state.rootURI().resolve(Strings.jsonPointerToURI(path.toString()));
            if (state.hasIDElement()) {
                Id id = new Id(state.baseURI(), state.idElement().getAsString(), state.idURI(), state.baseURIParent(), path, e, state.rootID(), rootURI);
                if (URIs.hasNonEmptyFragment(id.id)) {
                    if (ids.put(id.id, id) != null) {
                        throw new MalformedSchemaException("anchor not unique: name=" + id.value + " base=" + id.base + " rootID=" + id.rootID + " rootURI=" + id.rootURI, loc.get());
                    }
                    if (URIs.isNotFragmentOnly(state.idURI()) && ids.put(id.id, id = new Id(URIs.stripFragment(id.id), id.value, state.idURI(), id.base, id.path, id.element, id.rootID, id.rootURI)) != null) {
                        throw new MalformedSchemaException("ID not unique", loc.get());
                    }
                } else if (ids.put(id.id, id) != null) {
                    throw new MalformedSchemaException("ID not unique", loc.get());
                }
            }
            if (state.hasAnchorElement()) {
                URI unresolvedID = URI.parseUnchecked("#" + state.anchorElement().getAsString());
                Id id = new Id(state.baseURI().resolve(unresolvedID), state.anchorElement().getAsString(), unresolvedID, state.baseURI(), path, e, state.rootID(), rootURI);
                if (ids.put(id.id, id) != null) {
                    throw new MalformedSchemaException("anchor not unique: name=" + id.value + " base=" + id.base + " rootID=" + id.rootID + " rootURI=" + id.rootURI, loc.get());
                }
            }
        });
        return ids;
    }
}

