/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.qindesign.json.schema.Annotation;
import com.qindesign.json.schema.Error;
import com.qindesign.json.schema.Id;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.Locator;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Options;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.URIs;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import com.qindesign.json.schema.util.Ecma262Pattern;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ValidatorContext {
    private static final Class<?> CLASS = ValidatorContext.class;
    private static final Logger logger = Logger.getLogger(CLASS.getName());
    private static final Set<String> EVERY_OTHER_KEYWORD = Collections.emptySet();
    private static final List<Set<String>> KEYWORD_SETS = List.of(Set.of("$schema"), Set.of("$id"), Set.of("$recursiveAnchor", "$anchor", "$vocabulary"), EVERY_OTHER_KEYWORD, Set.of("additionalItems", "additionalProperties", "maxContains", "minContains"), Set.of("unevaluatedItems", "unevaluatedProperties"));
    private static final Map<String, Keyword> keywords = Collections.unmodifiableMap(ValidatorContext.findKeywords());
    private static final Map<String, Integer> keywordClasses;
    private final Map<URI, Boolean> vocabularies = new HashMap<URI, Boolean>();
    private Map<JSONPath, Map<String, Map<JSONPath, Annotation<?>>>> annotations;
    private Map<JSONPath, Map<JSONPath, Error<?>>> errors;
    private final JsonElement schema;
    private final boolean isMetaSchema;
    private State state;
    private final Map<URI, Id> knownIDs;
    private final Map<URI, URL> knownURLs;
    private final IdentityHashMap<JsonElement, Set<Id>> idsByElem;
    private final Map<URL, JsonElement> urlCache = new HashMap<URL, JsonElement>();
    private final Set<URI> validatedSchemas;
    private final Options options;
    private final boolean isCollectFailedAnnotations;
    private final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    private static Map<String, Keyword> findKeywords() {
        Set keywordClasses;
        try (ScanResult scanResult = new ClassGraph().acceptPackagesNonRecursive(new String[]{CLASS.getPackageName() + ".keywords"}).removeTemporaryFilesAfterScan().scan();){
            keywordClasses = scanResult.getAllClasses().stream().map(classInfo -> {
                try {
                    return Class.forName(classInfo.getName());
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
            }).filter(Keyword.class::isAssignableFrom).collect(Collectors.toSet());
        }
        HashMap<String, Keyword> keywords = new HashMap<String, Keyword>();
        for (Class c : keywordClasses) {
            try {
                Keyword keyword = (Keyword)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Keyword oldKeyword = keywords.putIfAbsent(keyword.name(), keyword);
                if (oldKeyword != null) {
                    logger.severe("Duplicate keyword: " + keyword.name() + ": " + c);
                    continue;
                }
                logger.fine("Keyword: " + keyword.name());
            }
            catch (ReflectiveOperationException | RuntimeException ex) {
                logger.log(Level.SEVERE, "Error loading keyword: " + c, ex);
                Throwable cause = ex.getCause();
                if (cause == null) continue;
                cause.printStackTrace();
            }
        }
        return keywords;
    }

    public ValidatorContext(URI baseURI, JsonElement schema, boolean isMetaSchema, Map<URI, Id> knownIDs, Map<URI, URL> knownURLs, Set<URI> validatedSchemas, Options options) {
        Objects.requireNonNull(baseURI, "baseURI");
        Objects.requireNonNull(schema, "schema");
        Objects.requireNonNull(knownIDs, "knownIDs");
        Objects.requireNonNull(knownURLs, "knownURLs");
        Objects.requireNonNull(validatedSchemas, "validatedSchemas");
        Objects.requireNonNull(options, "options");
        if (!baseURI.isAbsolute()) {
            throw new IllegalArgumentException("baseURI must be absolute");
        }
        if (URIs.hasNonEmptyFragment(baseURI)) {
            throw new IllegalArgumentException("baseURI has a non-empty fragment");
        }
        baseURI = baseURI.normalize();
        this.schema = schema;
        this.knownIDs = knownIDs;
        this.idsByElem = new IdentityHashMap();
        Id rootID = null;
        if (!knownIDs.isEmpty()) {
            for (Id id : knownIDs.values()) {
                Set ids = this.idsByElem.computeIfAbsent(id.element, elem -> new HashSet());
                if (id.id.rawFragment() == null && ids.stream().anyMatch(x -> x.id.rawFragment() == null)) {
                    throw new IllegalArgumentException("Duplicate known ID: " + baseURI + ": " + id.id);
                }
                if (!ids.add(id)) {
                    throw new IllegalArgumentException("Duplicate known ID: " + baseURI + ": " + id.id);
                }
                if (!id.path.isEmpty() || !baseURI.equals(id.base)) continue;
                if (rootID != null) {
                    throw new IllegalArgumentException("Duplicate root ID: " + baseURI + ": " + id.rootURI);
                }
                rootID = new Id(id.rootURI, null, id.unresolvedID, null, JSONPath.absolute(), id.element, id.rootID, id.rootURI);
            }
        } else {
            rootID = new Id(baseURI, null, baseURI, null, JSONPath.absolute(), schema, null, baseURI);
        }
        if (rootID != null) {
            this.knownIDs.putIfAbsent(rootID.id, rootID);
        }
        this.knownURLs = knownURLs;
        this.validatedSchemas = validatedSchemas;
        this.isMetaSchema = isMetaSchema;
        this.state = new State();
        this.state.baseURI = baseURI;
        this.state.spec = (Specification)((Object)options.get(Option.DEFAULT_SPECIFICATION));
        this.state.prevRecursiveBaseURI = null;
        this.state.recursiveBaseURI = null;
        this.state.schemaObject = null;
        this.state.isRoot = true;
        this.state.keywordParentLocation = null;
        this.state.absKeywordParentLocation = null;
        URI absKeywordLocation = rootID == null ? baseURI : (rootID.rootID == null ? rootID.id : rootID.rootID);
        this.state.loc = new Locator(JSONPath.absolute(), JSONPath.absolute(), absKeywordLocation);
        this.state.isCollectAnnotations = true;
        this.state.isCollectSubAnnotations = true;
        this.options = new Options(options);
        this.isCollectFailedAnnotations = this.isOption(Option.COLLECT_ANNOTATIONS_FOR_FAILED);
    }

    public Object option(Option opt) {
        return this.options.getForSpecification(opt, this.specification());
    }

    public boolean isOption(Option opt) {
        return Boolean.TRUE.equals(this.option(opt));
    }

    public boolean isCollectAnnotations() {
        return this.annotations != null;
    }

    public boolean isFailFast() {
        return this.annotations == null && this.errors == null;
    }

    public Pattern pattern(String regex) {
        return this.patternCache.computeIfAbsent(Ecma262Pattern.translate(regex), Pattern::compile);
    }

    public Map<URI, URL> knownURLs() {
        return Collections.unmodifiableMap(this.knownURLs);
    }

    public Set<URI> validatedSchemas() {
        return Collections.unmodifiableSet(this.validatedSchemas);
    }

    public boolean isMetaSchema() {
        return this.isMetaSchema;
    }

    public URI baseURI() {
        return this.state.baseURI;
    }

    public URI recursiveBaseURI() {
        return this.state.prevRecursiveBaseURI;
    }

    public void setBaseURI(URI uri) {
        this.state.baseURI = this.state.baseURI.resolve(uri);
    }

    public void setRecursiveBaseURI() {
        this.state.prevRecursiveBaseURI = this.state.recursiveBaseURI == null ? this.state.baseURI : this.state.recursiveBaseURI;
        this.state.recursiveBaseURI = this.state.baseURI;
    }

    public Specification specification() {
        return this.state.spec;
    }

    public void setSpecification(Specification spec) {
        Objects.requireNonNull(spec);
        this.state.spec = spec;
    }

    public boolean setVocabulary(URI id, boolean required) {
        return this.vocabularies.putIfAbsent(id, required) == null;
    }

    public Map<URI, Boolean> vocabularies() {
        return Collections.unmodifiableMap(this.vocabularies);
    }

    public boolean isRootSchema() {
        return this.state.isRoot;
    }

    public JSONPath schemaParentLocation() {
        return this.state.keywordParentLocation;
    }

    public JSONPath schemaLocation() {
        return this.state.loc.keyword;
    }

    public void setCollectSubAnnotations(boolean flag) {
        this.state.isCollectSubAnnotations = flag;
    }

    public JsonElement findAndSetRoot(URI id) {
        String path;
        Id theID = this.knownIDs.get(id);
        if (theID != null) {
            this.state.baseURI = theID.id;
            return theID.element;
        }
        id = URIs.stripFragment(id);
        StringBuilder sb = new StringBuilder();
        URI uri = id;
        do {
            URL url;
            if ((url = this.knownURLs.get(uri)) != null) {
                try {
                    JsonElement data = this.urlCache.computeIfAbsent(new URL(url, sb.toString()), url2 -> {
                        JsonElement jsonElement;
                        block8: {
                            InputStream in = url2.openStream();
                            try {
                                jsonElement = JSON.parse(in);
                                if (in == null) break block8;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException ex) {
                                    throw new UncheckedIOException(ex);
                                }
                            }
                            in.close();
                        }
                        return jsonElement;
                    });
                    if (data != null) {
                        this.state.schemaObject = null;
                        this.state.baseURI = uri;
                        return data;
                    }
                }
                catch (JsonParseException | UncheckedIOException | MalformedURLException data) {
                    // empty catch block
                }
            }
            if ((path = uri.rawPath()) == null) {
                path = "";
            }
            int lastSlashIndex = path.lastIndexOf(47);
            try {
                if (lastSlashIndex >= 0) {
                    if (sb.length() > 0) {
                        sb.insert(0, '/');
                    }
                    sb.insert(0, path.substring(lastSlashIndex + 1));
                    uri = new URI(uri.scheme(), uri.authority(), path.substring(0, lastSlashIndex), uri.query(), null);
                    continue;
                }
                sb.insert(0, path);
                uri = new URI(uri.scheme(), uri.authority(), "", uri.query(), null);
            }
            catch (URISyntaxException ex) {
                break;
            }
        } while (!path.isEmpty());
        JsonElement e = Validator.loadResource(id);
        if (e != null && Validator.isSchema(e)) {
            this.state.schemaObject = null;
            this.state.baseURI = id;
        }
        return e;
    }

    public Id findID(URI id) {
        return this.knownIDs.get(id);
    }

    public <T> void addAnnotation(String name, T value) throws MalformedSchemaException {
        if (this.annotations == null) {
            return;
        }
        if (!this.state.isCollectAnnotations && !this.isCollectFailedAnnotations) {
            return;
        }
        Annotation<T> a = new Annotation<T>(name, this.state.loc, value);
        a.setValid(this.state.isCollectAnnotations);
        Annotation<T> oldA = this.annotations.computeIfAbsent(this.state.loc.instance, k -> new HashMap()).computeIfAbsent(name, k -> new HashMap()).putIfAbsent(this.state.loc.keyword, a);
        if (oldA != null) {
            throw new MalformedSchemaException("annotation not unique: possible infinite loop", this.state.loc.absKeyword);
        }
    }

    public void addLocalAnnotation(String name, Object value) throws MalformedSchemaException {
        if (this.state.localAnnotations.putIfAbsent(name, value) != null) {
            throw new MalformedSchemaException("local annotation not unique: possible infinite loop", this.state.loc.absKeyword);
        }
    }

    public <T> void addError(boolean result, T value) throws MalformedSchemaException {
        if (this.errors == null) {
            return;
        }
        Error<T> err = new Error<T>(result, this.state.loc, value);
        Error<T> oldErr = this.errors.computeIfAbsent(this.state.loc.instance, k -> new HashMap()).putIfAbsent(this.state.loc.keyword, err);
        if (oldErr != null) {
            throw new MalformedSchemaException("error not unique: possible infinite loop", this.state.loc.absKeyword);
        }
    }

    public boolean hasAnnotation(String name) {
        if (this.annotations == null || !this.state.isCollectAnnotations) {
            return false;
        }
        return this.annotations.getOrDefault(this.state.loc.instance, Collections.emptyMap()).getOrDefault(name, Collections.emptyMap()).containsKey(this.state.loc.keyword);
    }

    public boolean hasError() {
        if (this.errors == null) {
            return false;
        }
        return this.errors.getOrDefault(this.state.loc.instance, Collections.emptyMap()).containsKey(this.state.loc.keyword);
    }

    public Map<JSONPath, Annotation<?>> annotations(String name) {
        if (this.annotations == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.annotations.getOrDefault(this.state.loc.instance, Collections.emptyMap()).getOrDefault(name, Collections.emptyMap()));
    }

    public Object localAnnotation(String name) {
        return this.state.localAnnotations.get(name);
    }

    private static URI resolveAbsolute(URI base, JSONPath path) {
        if (path == null) {
            return base;
        }
        Object fragment = path.isAbsolute() ? path.toString() : Optional.ofNullable(base.fragment()).orElse("") + "/" + path;
        if (((String)fragment).indexOf(46) >= 0) {
            fragment = JSONPath.fromJSONPointer((String)fragment).normalize().toString();
        }
        try {
            return base.resolve(new URI(null, null, null, null, (String)fragment));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Unexpected bad URI", ex);
        }
    }

    private static URI resolveAbsolute(URI base, String name) {
        if (name == null) {
            return ValidatorContext.resolveAbsolute(base, (JSONPath)null);
        }
        return ValidatorContext.resolveAbsolute(base, JSONPath.fromElement(name));
    }

    private static JSONPath resolvePointer(JSONPath base, String name) {
        if (name == null) {
            return base;
        }
        return base.append(name);
    }

    public void schemaError(String err, JSONPath path) throws MalformedSchemaException {
        throw new MalformedSchemaException(err, ValidatorContext.resolveAbsolute(this.state.loc.absKeyword, path));
    }

    public void schemaError(String err, String name) throws MalformedSchemaException {
        this.schemaError(err, JSONPath.fromElement(name));
    }

    public void schemaError(String err) throws MalformedSchemaException {
        this.schemaError(err, (JSONPath)null);
    }

    public void checkValidSchema(JsonElement e, String name) throws MalformedSchemaException {
        if (!Validator.isSchema(e)) {
            throw new MalformedSchemaException("not a valid JSON Schema", ValidatorContext.resolveAbsolute(this.state.loc.absKeyword, name));
        }
    }

    public void checkValidSchema(JsonElement e) throws MalformedSchemaException {
        this.checkValidSchema(e, null);
    }

    public JsonElement followPointer(URI baseURI, JsonElement e, String ptr) {
        if (e == null) {
            return null;
        }
        URI newBase = baseURI;
        for (String part : JSONPath.fromJSONPointer(ptr)) {
            try {
                int index = Integer.parseInt(part);
                if (e.isJsonArray()) {
                    if (index >= e.getAsJsonArray().size()) {
                        return null;
                    }
                    e = e.getAsJsonArray().get(index);
                    continue;
                }
            }
            catch (NumberFormatException index) {
                // empty catch block
            }
            if (!e.isJsonObject()) {
                return null;
            }
            Optional<Id> id = this.idsByElem.computeIfAbsent(e, elem -> Collections.emptySet()).stream().filter(x -> x.id.rawFragment() == null).findFirst();
            if (id.isPresent()) {
                newBase = id.get().id;
            }
            if ((e = e.getAsJsonObject().get(part)) != null) continue;
            return null;
        }
        this.state.baseURI = newBase;
        return e;
    }

    public boolean apply(JsonElement instance, Map<JSONPath, Map<String, Map<JSONPath, Annotation<?>>>> annotations, Map<JSONPath, Map<JSONPath, Error<?>>> errors) throws MalformedSchemaException {
        this.annotations = annotations;
        this.errors = errors;
        boolean retval = this.apply(this.schema, null, null, instance, null);
        if (retval) {
            this.addError(true, null);
        } else {
            this.addError(false, "schema didn't validate");
        }
        if (annotations != null) {
            annotations.forEach((key, value) -> value.entrySet().removeIf(e -> ((Map)e.getValue()).isEmpty()));
            annotations.entrySet().removeIf(e -> ((Map)e.getValue()).isEmpty());
        }
        return retval;
    }

    public boolean apply(JsonElement schema, String name, URI absSchemaLoc, JsonElement instance, String instanceName) throws MalformedSchemaException {
        Optional<Id> id;
        if (JSON.isBoolean(schema)) {
            return schema.getAsBoolean();
        }
        URI absKeywordLocation = null;
        if (schema.isJsonObject() && (id = this.idsByElem.computeIfAbsent(schema, elem -> Collections.emptySet()).stream().filter(x -> x.id.rawFragment() == null).findFirst()).isPresent()) {
            absKeywordLocation = id.get().id;
            this.state.baseURI = id.get().id;
        }
        if (absKeywordLocation == null) {
            absKeywordLocation = absSchemaLoc == null ? ValidatorContext.resolveAbsolute(this.state.loc.absKeyword, name) : absSchemaLoc;
        }
        if (!schema.isJsonObject()) {
            throw new MalformedSchemaException("not a valid JSON Schema", absKeywordLocation);
        }
        JsonObject schemaObject = schema.getAsJsonObject();
        if (schemaObject.size() == 0) {
            return true;
        }
        JSONPath keywordLocation = ValidatorContext.resolvePointer(this.state.loc.keyword, name);
        JSONPath instanceLocation = ValidatorContext.resolvePointer(this.state.loc.instance, instanceName);
        State parentState = this.state;
        this.state = new State(this.state);
        this.state.isRoot = this.state.schemaObject == null;
        this.state.schemaObject = schemaObject;
        this.state.keywordParentLocation = keywordLocation;
        this.state.absKeywordParentLocation = absKeywordLocation;
        this.state.loc = new Locator(instanceLocation, this.state.loc.keyword, absKeywordLocation);
        this.state.isCollectSubAnnotations = this.state.isCollectAnnotations = parentState.isCollectSubAnnotations;
        List ordered = schemaObject.entrySet().stream().filter(e -> keywords.containsKey(e.getKey())).sorted(Comparator.comparing(e -> keywordClasses.get(e.getKey()))).collect(Collectors.toList());
        boolean result = true;
        for (Map.Entry m2 : ordered) {
            Keyword k = keywords.get(m2.getKey());
            if (this.specification().compareTo(Specification.DRAFT_2019_09) < 0 && schemaObject.has("$ref") && !k.name().equals("$ref") || this.applyKeyword(k, (JsonElement)m2.getValue(), instance)) continue;
            result = false;
            if (!this.isFailFast()) continue;
            break;
        }
        if (!result && this.annotations != null) {
            Predicate<Map.Entry> pred = e -> ((JSONPath)e.getKey()).startsWith(keywordLocation);
            if (!this.isCollectFailedAnnotations) {
                this.annotations.getOrDefault(instanceLocation, Collections.emptyMap()).values().forEach(v -> v.entrySet().removeIf(pred));
            } else {
                this.annotations.getOrDefault(instanceLocation, Collections.emptyMap()).values().forEach(m -> m.entrySet().stream().filter(pred).forEach(e -> ((Annotation)e.getValue()).setValid(false)));
            }
        }
        if (result && this.errors != null) {
            this.errors.entrySet().stream().filter(e -> ((JSONPath)e.getKey()).startsWith(instanceLocation)).forEach(e -> ((Map)e.getValue()).values().stream().filter(err -> !err.result && err.loc.keyword.startsWith(keywordLocation)).forEach(a -> a.setPruned(true)));
        }
        this.state = parentState;
        return result;
    }

    public boolean applyKeyword(Keyword k, JsonElement schema, JsonElement instance) throws MalformedSchemaException {
        Locator loc = this.state.loc = new Locator(this.state.loc.instance, ValidatorContext.resolvePointer(this.state.keywordParentLocation, k.name()), ValidatorContext.resolveAbsolute(this.state.absKeywordParentLocation, k.name()));
        boolean isCollectSubAnnotations = this.state.isCollectSubAnnotations;
        boolean result = true;
        String msg = null;
        if (!k.apply(schema, instance, this.state.schemaObject, this)) {
            result = false;
            msg = "\"" + k.name() + "\" didn't validate";
        }
        this.state.loc = loc;
        this.state.isCollectSubAnnotations = isCollectSubAnnotations;
        if (!this.hasError()) {
            this.addError(result, msg);
        }
        return result;
    }

    static {
        Map<String, Integer> classes = IntStream.range(0, KEYWORD_SETS.size()).boxed().flatMap(i -> KEYWORD_SETS.get((int)i).stream().map(name -> Map.entry(name, i))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        int otherClass = KEYWORD_SETS.indexOf(EVERY_OTHER_KEYWORD);
        keywords.keySet().forEach(name -> classes.putIfAbsent((String)name, otherClass));
        keywordClasses = Collections.unmodifiableMap(classes);
    }

    private static final class State {
        JsonObject schemaObject;
        boolean isRoot;
        URI baseURI;
        Specification spec;
        URI prevRecursiveBaseURI;
        URI recursiveBaseURI;
        JSONPath keywordParentLocation;
        URI absKeywordParentLocation;
        Locator loc;
        boolean isCollectAnnotations;
        boolean isCollectSubAnnotations;
        final Map<String, Object> localAnnotations = new HashMap<String, Object>();

        State() {
        }

        State(State state) {
            this.schemaObject = state.schemaObject;
            this.isRoot = state.isRoot;
            this.baseURI = state.baseURI;
            this.spec = state.spec;
            this.prevRecursiveBaseURI = state.prevRecursiveBaseURI;
            this.recursiveBaseURI = state.recursiveBaseURI;
            this.keywordParentLocation = state.keywordParentLocation;
            this.absKeywordParentLocation = state.absKeywordParentLocation;
            this.loc = state.loc;
            this.isCollectAnnotations = state.isCollectAnnotations;
            this.isCollectSubAnnotations = state.isCollectSubAnnotations;
        }
    }
}

