/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.ValidatorContext;

public class AdditionalItems
extends Keyword {
    public static final String NAME = "additionalItems";

    public AdditionalItems() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        context.checkValidSchema(value);
        JsonElement items = parent.get("items");
        if (items == null || items.isJsonObject()) {
            return true;
        }
        if (!items.isJsonArray()) {
            return true;
        }
        if (!instance.isJsonArray()) {
            return true;
        }
        JsonArray schemaArray = items.getAsJsonArray();
        JsonArray array = instance.getAsJsonArray();
        int processedCount = Math.min(schemaArray.size(), array.size());
        StringBuilder sb = new StringBuilder();
        for (int i = processedCount; i < array.size(); ++i) {
            if (context.apply(value, null, null, array.get(i), Integer.toString(i))) continue;
            if (context.isFailFast()) {
                return false;
            }
            if (sb.length() > 0) {
                sb.append(", ");
            } else {
                sb.append("invalid additional items: ");
            }
            sb.append(i);
        }
        if (processedCount < array.size()) {
            context.addAnnotation(NAME, true);
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

